#!/usr/bin/X11/wish-6.7 -f

# *********************************************************************
# Simple Wish script for communicating with Lisp
# Note: this assumes readlns.awk is in the current directory.
# Jonathan Kaye, kaye@linc.cis.upenn.edu, August 1991
#    [Revised to remove dependence on awk, July 1994]
# *********************************************************************

# sendlisp
# Sends a character to Lisp then waits for a response

proc sendlisp char {
	puts stdout $char
	flush stdout

	set ex ""

	for {gets stdin i} {[string compare @ $i] != 0} \
	    {gets stdin i} {
		# filter the nulls
		if {[string length $i] != 0} {
		    set ex "$ex\n$i"}}

# For debugging -- See what we read
#	puts stderr "READ: ** $ex **\n"

	foreach i $ex {eval $i}
    }

# telllisp
# Sends characters to Lisp without waiting for a response

proc telllisp char {
        puts stdout $char
        }

# TELLUSER ##############################################################
# Put up a window giving the user some information.  The user removes the
# window by pressing Return within the window.

proc telluser {windname text} {

	# Make sure message isn't already shown!
	set w $windname
	catch {destroy $w}

	toplevel $w -bd 1 -relief raised

	message $w.msg -text $text \
                       -justify center \
		       -border 2 \
		       -relief raised \
                       -font *times-medium-r-normal--*-180*

	pack append $w  $w.msg {top fill} \
			[message $w.kill \
			    -justify center \
	                    -font *times-medium-r-normal--*-120* -aspect 400 \
 			    -text "Press left button to remove"] bottom

	bind $w.msg <1> "after 1 destroy $w"
	bind $w.kill <1> "after 1 destroy $w"
}


proc mainwind {} {

	frame .buts -border 1
	message .msg -text {I just want to say something}
	pack append .buts \
		[button .buts.1 -text {Build Window} \
			-command {sendlisp buildproc}] {top expand fill} \
		[button .buts.2 -text {Display message} \
			-command {sendlisp dispmsg}] {top expand fill} \
		[button .buts.3 -text {Change message} \
			-command {sendlisp chgmsg}] {top expand fill} \
		[button .buts.4 -text {Quit} \
			-command {sendlisp exit; after 1 destroy .}] {top expand fill}
	pack append . .msg {top expand fill} .buts {top expand fill}
}

#########################################################################
### MAIN WINDOW

mainwind

# Wait for Lisp to send something before starting

 set ex ""

 for {gets stdin i} {[string compare @ $i] != 0} \
     {gets stdin i} {
#        for debugging, see what comes over
#	 puts stderr "S: $i\n"
 	set ex "$ex\n$i"}
 
 foreach b $ex {eval $b}
