;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  File: matrix-tutorial.lisp
;;;  Author: Heeger
;;;  Description: 
;;;  Creation Date: 6/93
;;;  ----------------------------------------------------------------
;;;    Object-Based Vision and Image Understanding System (OBVIUS),
;;;      Copyright 1988, Vision Science Group,  Media Laboratory,  
;;;              Massachusetts Institute of Technology.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; *** UNFINISHED ***

(obv-require :matrix)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Matrix multiplication in Obvius:

;; Obvius provides several functions for doing matrix multiplication.

(setq A (make-matrix '((1 2)
		       (3 4))))
(setq B (make-matrix '((-1 2)
		       (3 -4))))

;; Multiply A by B:
(print-values (matrix-mul A B))

;; Multiply A-transpose by B:
(print-values (matrix-transpose-mul A B))

;; Multiply A by B-transpose:
(print-values (matrix-mul-transpose A B))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; SVD (Singular Value Decomposition):

;; The SVD decomposes a matrix into the product of the three
;; components:
;;     A = U S V^t
;; where ^t means transpose.  A is the original MxN matrix, U is an
;; MxM orthogonormal matrix, V is an NxN orthogonormal matrix, and S
;; is an MxN matrix with non-zero elements only along the diagonal.
;; Note that Obvius returns S as a vector whose length is the smaller
;; of the two dimensions.

;; Let's try it on a randomly filled 10x5 matrix:
(setq A (make-array '(10 5) :element-type 'single-float))
(randomize A 1.0 :-> A)
(multiple-value-setq (S U V) (singular-value-decomposition A))

;; We can check to see that the decomposition worked.  Multiplying the
;; U, S, and V matrices should give back the original matrix.  First
;; we need to put the entries of S into a matrix and then use matrix
;; multiplication:
(setq Smat (make-array (dimensions A) :element-type 'single-float :initial-element 0.0))
(loop for i from 0 below (x-dim S) do
      (setf (aref Smat i i) (aref S i)))
(range (sub A (matrix-mul-transpose (matrix-mul U Smat) V)))

;; Check that U and V are orthogonormal matrices:
(and (identity-p (matrix-transpose-mul V V))
     (identity-p (matrix-mul-transpose V V))
     (identity-p (matrix-transpose-mul U U))
     (identity-p (matrix-mul-transpose U U)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Four fundamental subspaces:

;; Consider a matrix A as a linear transform, y=Ax, that transforms
;; x (N-dimensional vectors) into y (M-dimensional vectors).

;; If the matrix A is singular then there is some subspace of x (some
;; subspace of M-space) that is mapped to zero, Ax=0.  This is called
;; the "row-nullspace" of A.

;; There is also a subspace of y (some subspace of M-space) that can
;; be reached by A.  This is called the "column-space" of A.  The
;; dimension of the column-space is called the rank of A.

;; The SVD explicitly constructs orhtonormal bases for the
;; row-nullspace and column-space of A.  The columns of U, whose
;; same-numbered elements in S are non-zero, are an orthonormal set of
;; basis vectors that span the column-space of A.  The remaining
;; colums of U span the row-nullspace of A^t (also called the
;; column-nullspace of A).

;; The columns of V (rows of V^t), whose same-numbered elements in S
;; are zero, are an orthonormal set of vectors that span the
;; row-nullspace of A.  The remaining columns of V span the
;; column-space of A^t (also called the row-space of A).

;; Obvius provides functions to get each of these basis sets:

(setq col-space-basis (col-space A))
(setq col-nullspace-basis (col-null-space A))
(setq row-space-basis (row-space A))

;; For our matrix, there is no row nullspace so the following gives an
;; error message:

(setq row-nullspace-basis (row-null-space A))

;; The basis vectors for (col-space A) are the columns of
;; col-space-basis:

(print-values col-space-basis)

;; The basis vectors for (col-null-space A) are the columns of
;; col-nullspace-basis:

(print-values col-nullspace-basis)

;; These two spaces, col-nullspace-basis and col-space-basis, are
;; orthogonal.  So we get all zeros if we multiply the columns of one
;; by the columns of the other:

(print-values (matrix-transpose-mul col-space-basis col-nullspace-basis))

;; For more information on these four fundamental subspaces, consult a
;; linear algebra text.  Linear Algebra and its Applications by Strang
;; is excellent.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; SVD of a square, symmetric, positive definite matrix:

;; Covariance...

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Least Squares:

;; Find vector x that comes closest to satisfying Ax=b.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Least Squares:

;; Find unit vector x that comes closese to satisfying Ax=0.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Principle Components Analysis:


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Local Variables:
;;; buffer-read-only: t 
;;; fill-column: 79
;;; End:

