;;;; .obvius  --  OBVIUS startup configuration file 

;;; This file is loaded at startup by OBVIUS versions 2.1 and higher.
;;; It is loaded by OBVIUS after it initializes the window system (see
;;; "obvius-window-init.lisp") and starts the top-level
;;; read-eval-print loop. Below are some ideas of what you can put in
;;; your own personal (i.e. in your home directory) obvius-init.lisp
;;; file.

(in-package 'user)

;;; Load personal lisp init file, if it exists
(let ((fl (probe-file "~/lisp-init.lisp")))
  (when fl (load fl)))	

;;; -----------------------------------------------------------------
;;; Floating-point Exceptions: Uncomment this line to prevent floating
;;; point exceptions in foreign function (eg, C) code from generating
;;; continuable errors in Lisp.  Many, but not all, of the OBVIUS C
;;; functions trap these errors in a more graceful way.

;(setf (enabled-floating-point-traps) nil)

;;; -----------------------------------------------------------------
;;; Memory stuff:

;;; Set upper limit on Lisp process size to this number of 64k segments.  
;;; This is a Lucid Lisp function.  You should set it a bit below the
;;; total size of your virtual memory (find this out with "/etc/pstat -s").
;(LCL:change-memory-management :growth-limit 1024)

;;; Expand lisp reserved memory (this will be used by the OBVIUS
;;; static memory allocator).
(change-memory-management :expand-reserved 90)	;6Mb

;;; Expand the Lisp dynamic areas by this many 64k segments.
;(LCL:change-memory-management :expand 500)

;;; Expand OBVIUS's float and byte static heaps by
;;; *heap-growth-rate* elements.
;(expand-heap 'float)
;(expand-heap '(unsigned-byte 8))

;;; -----------------------------------------------------------------
;;; OBVIUS window setup:

;;; Put up a control panel with menus, status line, and mouse documentation.
;(make-control-panel)

;;; Create some standard-size panes (OBVIUS windows)
;(new-pane :top 450)
;(new-pane :top 150)
;(new-pane :top 560)

;;; -----------------------------------------------------------------
;;; OBVIUS global parameters.  NOTE: Parameters that control the
;;; initialization of the window system should be set in
;;; obvius-window-init.lisp.  Run the function (obvius-parameters) to
;;; list all currently defined variables and their values.

;(setq *auto-bind-loaded-images* t)
;(setq *auto-update-pictures* nil)
;(setq *auto-destroy-orphans* t)
;(setq *preserve-picture-pane* t)

(setq *max-print-vals* 12)
;(setq *y-print-range* '(0.0 1.0))
;(setq *x-print-range* '(0.0 1.0))
;(setq *div-by-zero-result* 0.0)

;(setq *default-printer* (environment-variable "PRINTER"))

(setq *auto-expand-heap* t)
;(setq *auto-expand-heap* nil)
;(setq *heap-growth-rate* 1048576)	;default # elements by which static
					;heaps are expanded

;(setq *machine-tolerance* least-positive-single-float)
;(setq *tolerance* e-10)

;;; This stuff is for Gnu Emacs:
;;; Local Variables:
;;; mode: lisp
;;; End:
