;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  File: numerical-recipes.lisp
;;;  Author: Chichilnisky
;;;  Description: Lisp interface to SELECTED numerical-recipes code.
;;;  Creation Date: 5/23/92
;;;  ----------------------------------------------------------------
;;;    Object-Based Vision and Image Understanding System (OBVIUS),
;;;      Copyright 1988, Vision Science Group,  Media Laboratory,  
;;;              Massachusetts Institute of Technology.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(in-package 'obvius)

;;; *** FFI stuff is in here, not consistent with the lucid-ffi.lisp setup,
;;; because we want this to be a loadable module and we don't want the user to
;;; have to screw around with the C Makefile.

(unless (probe-file *numerical-recipes-library*)
  (error "Numerical Recipes ~a not found - check your site-paths.lisp file."
	 *numerical-recipes-library*))

;;; These numerical recipes functions are expected to exist
;;; in the numerical recipes library defined by the global.
;;; These are simply the interface definitions.
(lcl::def-foreign-function (gammp (:return-type :single-float))
    (a :double-float) (x :double-float))
(lcl::def-foreign-function (gammq (:return-type :single-float))
    (a :double-float) (x :double-float))
(lcl::def-foreign-function (gammln (:return-type :single-float))
    (a :double-float))
(lcl::def-foreign-function (betai (:return-type :single-float))
    (a :double-float) (b :double-float) (x :double-float))
(lcl::def-foreign-function (factrl (:return-type :single-float))
    (n :fixnum))
(lcl::def-foreign-function (factln (:return-type :single-float))
    (n :fixnum))
(lcl::def-foreign-function (bico (:return-type :single-float))
    (n :fixnum) (k :fixnum))

;;; The nrerror() routine must be defined here,
;;; since the NR version calls exit(), which kills the Lisp process.
(LCL:def-foreign-callable (nrerror (:return-type :signed-32bit))
    ((string :simple-string))
  (warn (concatenate 'string "Numerical Recipes error - " string))
  0)

;;; Load the only the routines we want from the Numerical Recipes (TM) library.
;;; Do not load in NRERROR(), since the Lisp version must override it.
(let ((foreign-function-names (list "_gammp" "_gammq" "_gammln" "_betai"
				    "_factrl" "_factln" "_bico")))
  (lcl::load-foreign-libraries foreign-function-names (list *numerical-recipes-library*)))

;;; Local Variables:
;;; buffer-read-only: t 
;;; fill-column: 79
;;; End:
