;;; Some re-definitions of global defaults.

(setf *default-arm-bigness* 0)
(setf *default-bay-bigness* 0)
(setf *default-truck-bigness* 1000)
(setf *default-link-fuel-drag* 0)
(setf *default-link-speed-drag* 0)

;;; The 473 world.

(defun create-world ()
  (let ((world 
	 (make-world (make-map :nodes `((node-1 :display-info ,(->rectangle 410 110 75 50))
					(node-2 :display-info ,(->rectangle 210  10 75 50))
					(node-3 :display-info ,(->rectangle  10 110 75 50))
					(node-4 :display-info ,(->rectangle 210 210 75 50)))
			       :sectors '((sector-1 (node-1
						     node-2
						     node-3
						     node-4
						     road-1
						     road-2
						     road-3
						     road-4)))
			       :links  '((road-1 node-1 node-2 nw :length 100)
					 (road-2 node-2 node-3 sw :length 100)
					 (road-3 node-3 node-4 se :length 100 :max-load 1070)
					 (road-4 node-4 node-1 ne :length 100)))
		     nil)))

    ;; Place 2 fuel drums (of bigness 5 and capacity 10) into node-1.
    (dotimes (x 2)
      (populate-world world (make-fuel-drum 5 10) 'node-1))
        
    ;; Place 10 fuel drums (of bigness 5 and capacity 10) into node-3.
    (dotimes (x 10)
      (populate-world world (make-fuel-drum 5 10) 'node-3))
    
    ;; Place 3 rocks (of bigness 10) into node-2.
    (dotimes (x 3)
      (populate-world world (make-rock 10) 'node-2))
    
    ;; Place 2 glasses into node-2.
    (dotimes (x 2)
      (populate-world world (make-glass) 'node-2))
    
    ;; Place 3 rocks (of bigness 20) into node-4.
    (dotimes (x 3)
      (populate-world world (make-rock 20) 'node-4))
    
    ;; Place a bomb into node-4.
    (populate-world world (make-bomb) 'node-4)
    
    ;; Place a bomb into node-2.
    (populate-world world (make-bomb) 'node-2)
    
    world))

;;; The 473 truck.

(defun make-473-truck ()
  (make-truck :mpg  10
	      :mph 100
	      :arm1 (arm-1 :capacity 15)
	      :arm2 (arm-2 :capacity 20)
	      :fuel-tank (fuel-tank :capacity 10 :amount-held 10)))

;;; Glass.

(defobject glass (thingoid)
  (bigness 5)
  (state 'intact))

(defun make-glass (&optional (bigness 5) (state 'intact))
  (make-sim-object 'glass 'bigness bigness 'state state))

(defmethod bitmap-pathname ((object glass))
  (if (eq (query object 'state) 'broken)
      (make-bitmap-pathname 'broken-glass)
    (make-bitmap-pathname 'glass)))

;;; Bomb.

(defobject bomb (thingoid)
  (bigness 10))

(defun make-bomb (&optional (bigness 10))
  (make-sim-object 'bomb 'bigness bigness))

(defmethod set-object ((object bomb) setter &rest set-values)
  (mapcar #'(lambda (obj) (if (eq (query obj 'kind) 'glass)
			      (setp obj 'state 'broken)))
	  (my-container-neighbors object)))
