
(load-extension "bomb")
(load-extension "radio")
(load-extension "radiation")
(load-extension "siphon")
(load-extension "speaker")

(defun create-world ()
  (let* ((speakers (list (make-sim-object 'loudspeaker)
			 (make-sim-object 'loudspeaker)))
	 (map (make-map 
	       :nodes 
	       `((battle :display-info ,(->rectangle 25 25 75 50))
		 (depot  :display-info ,(->rectangle 120 25 75 50))
		 (sound  :display-info ,(->rectangle 25 100 75 50))
		 (radio  :display-info ,(->rectangle 120 100 75 50))
		 (radiation :display-info ,(->rectangle 210 25 75 50)))
	       
	       :links '((road-1 battle depot e)
			(road-2 battle sound s)
			(road-3 battle radio se)
			(road-4 sound radio e)
			(road-5 sound depot ne)
			(road-6 depot radio s)
			(road-7 depot radiation e)
			(road-8 radio radiation ne))
	       
	       :sectors '((sector-1 (
			   battle depot sound radio radiation
			   road-1 road-2 road-3 road-4 road-5 road-6
			   road-7 road-8)))))
	    
	 (events `(,(make-exogenous-event
		     :time-period '(10)
		     :set-properties `((,(first speakers))
				       nil
				       (set "HI! Welcome to the sound node!")))))
    
	 (world (make-world map events)))
	 
    
    ;;; Install events that depend on the world already being defined

    ;; The sun goes up and down every 5 hours
    (install-exogenous-event
     (make-exogenous-event :time-period '(300) ; i.e. Days are 10 hours long
			   :set-properties `(,(world-sectors world)
					     nil
					     (daytime (PROB-COND
						       ((#'eq ((ARG 0) daytime) T)
							nil)
						       (T T)))))
     world)
    
;;;    ;; Sector 1 is moderately rainy
;;;    
    (install-exogenous-event
     (make-exogenous-event :time-period '((dist-mean-var 400 200) ; Time between
					  (dist-mean-var 100 50)) ; duration
			   :set-properties `((,(sector 'sector-1 world))
					     nil
					     (weather (PROB-COND
						       ((#'eq ((ARG 0) weather)
							      sunny)
							rainy)
						       (T sunny)))))
     world)
    
    ;; Every 100 time units or so, enemies appear in battle, and the adjoining
    ;; roads, that hang around for 100 or so units.

    (install-exogenous-event
     (make-exogenous-event :time-period '((dist-mean-var 100 0))
			   :set-properties `((,(make-enemy-unit-maker
						(node-list '(battle) world)))

					     nil
					     (set (prob-dist
						   (0.5 (1 (dist-mean-var 100 100)))
						   (0.3 (2 (dist-mean-var 100 100)))
						   (0.2 (3 (dist-mean-var 100 100)))))))
     world)
    
    ;; Populate the world.

    ;; Load the battle node up with weapons and ammo and a little fuel
    (dotimes (x 2)
      (populate-world world (make-fuel-drum 5 10) 'battle))
    (dotimes (x 1)
      (populate-world world (make-weapon) 'battle))
    (dotimes (x 2)
      (populate-world world (make-bomb :effectiveness 50
				       :fuse-delay 10)
		      'battle))
    (dotimes (x 6)
      (populate-world world (make-ammo-box 2 10) 'battle))
    
    ;; The depot has fuel, tires, and some tools
    (dotimes (x 8)
      (populate-world world (make-fuel-drum 5 10) 'depot))
    (dotimes (x 1)
      (populate-world world (make-tire) 'depot))
    (dotimes (x 1)
      (populate-world world (make-sim-object 'mud-tires) 'depot))
    (dotimes (x 1)
      (populate-world world (make-winch) 'depot))
    (dotimes (x 1)
      (populate-world world (make-sim-object 'siphon) 'depot))
    
    ;; Radiation has some radioactive objects
    (dotimes (x 4)
      (populate-world world (make-sim-object 'uranium) 'radiation))
    (dotimes (x 1)
      (populate-world world (make-sim-object 'radiation-sensor) 'radiation))
    (dotimes (x 2)
      (populate-world world (make-sim-object 'lead-box) 'radiation))
    
    ;; Sound has objects that deal with sound
    (populate-world world (first speakers) 'sound)
    (populate-world world (second speakers) 'sound)
    (dotimes (x 1)
      (populate-world world (make-sim-object 'tape-recorder) 'sound))
    (dotimes (x 1)
      (populate-world world (make-sim-object 'microphone) 'sound))
    (dotimes (x 1)
      (populate-world world (make-sim-object 'soundproof-box) 'sound))
    (dotimes (x 1)
      (populate-world world (make-sim-object 'box) 'sound))

    ;; Radio contains radios
    (dotimes (x 3)
      (populate-world world (make-sim-object 'radio) 'radio))
    
    world))



