
(load-extension "radio")
(load-extension "multi-agent-objects")
(load-extension "speaker")

(defun create-world ()
  (let* (
	 (map (make-map 
	       :nodes 
	       `((headquarters :display-info ,(->rectangle 200 150 100 50))
		 (north-node   :display-info ,(->rectangle 200 25 100 50))
		 (south-node   :display-info ,(->rectangle 200 275 100 50))
		 (west-node    :display-info ,(->rectangle 25 150 100 50))
		 (east-node    :display-info ,(->rectangle 425 150 100 50)))
	       
	       :links '((north-road headquarters north-node n)
			(south-road headquarters south-node s
			            :max-load 2000)
			(east-road headquarters east-node e)
			(west-road headquarters west-node w)
			(nw-road north-node west-node sw)
			;; This road is slippery
			(ne-road north-node east-node se
			 :pavement gravel
			 :length 70)
			
			;; This road is dangerous (especially with the
			;;   weather there)
			(sw-road south-node west-node nw
			 :pavement dirt
			 :length 70)
			(se-road south-node east-node ne))
	       
	       :sectors '((ne-sector (north-node 
				      east-node 
				      headquarters
				      north-road east-road
				      ne-road))
			  (sw-sector (south-node
				      west-node
				      south-road
				      west-road
				      sw-road
				      nw-road
				      se-road)))))
	    (events `())
	  (world (make-world map events)))
	 
    
    ;;; Install events that depend on the world already being defined

    ;; The sun goes up and down every 5 hours
    (install-exogenous-event
     (make-exogenous-event :time-period '(300) ; i.e. Days are 10 hours long
			   :set-properties `(,(world-sectors world)
					     nil
					     (daytime (PROB-COND
						       ((#'eq ((ARG 0) daytime) T)
							nil)
						       (T T)))))
     world)
    
    ;;   The NE Sector is moderately rainy

    (install-exogenous-event
     (make-exogenous-event :time-period '((dist-mean-var 400 200) ; Time between
					  (dist-mean-var 100 50)) ; duration
			   :set-properties `((,(sector 'ne-sector world))
					     nil
					     (weather (PROB-COND
						       ((#'eq ((ARG 0) weather)
							      sunny)
							(prob-dist
							 (0.8 rainy)
							 (0.2 stormy)))
						       (T sunny)))))
     world)
    
    
    ;; The SW sector is very rainy

    (install-exogenous-event
     (make-exogenous-event :time-period '((dist-mean-var 50 200) ; Time between
					 (dist-mean-var 100 50)) ; duration
			   :set-properties `((,(sector 'sw-sector world))
					     nil
					     (weather (PROB-COND
						       ((#'eq ((ARG 0) weather)
							      sunny)
							(prob-dist
							 (0.6 rainy)
							 (0.4 stormy)))
						       (T sunny)))))
     world)


    ;; There is only one fuel barrel at HQ (the starting node).
    ;;   That means that one of the trucks will have to
    ;;   go fetch more for the others.
    
    (dotimes (x 1)
      (populate-world world (make-fuel-drum 5 10) 'headquarters))
    (populate-world world (make-sim-object 'refrigerator) 'headquarters)
    
    ;; The north node has the fuel
    (dotimes (x 8)
      (populate-world world (make-fuel-drum 5 10) 'north-node))
    (dotimes (x 3)
      (populate-world world (make-sim-object 'liquid-sensor) 'north-node))
    
    world))


(defmacro make-cooperative-truck (&rest args)
  `(make-truck :bay1 (bay-1 :holdings ((make-sim-object 'loudspeaker)
				       (make-sim-object 'microphone)
				       (make-sim-object 'radio)))
	       
	       ,@args))

