(load-extension "speaker")
(load-extension "demo-extensions")
(load-extension "radiation")

(defun create-world ()
  (let* (temp
	 (map (make-map :nodes 
               `((sensor-node :display-info ,(->rectangle 50 225 75 50))
		 (battle :display-info ,(->rectangle 25 25 75 50))
		 (demand-1 :display-info ,(->rectangle 400 25 75 50))
		 (demand-2 :display-info ,(->rectangle 225 50 75 50))
		 (int-1 :display-info ,(->rectangle 100 125 20 20))
		 (int-2 :display-info ,(->rectangle 390 150 20 20))
		 (int-3 :display-info ,(->rectangle 100 165 20 20))
		 (int-4 :display-info ,(->rectangle 390 190 20 20))
		 (fuel-depot :display-info ,(->rectangle 320 100 65 35))
		 (maint-1 :display-info ,(->rectangle 425 225 50 50)))
	       
	       :links '((road-1 int-1 battle n)
			(road-2 demand-2 battle nw)
			(road-3 int-1 demand-2 ne)
			(road-4 fuel-depot demand-1 ne)
			(road-5 int-2 demand-1 n)
			(road-6 int-2 fuel-depot nw)
			(road-7 int-1 int-2 e)
			(road-8 demand-2 fuel-depot e)
			(road-9 sensor-node int-3 n)
			(road-10 sensor-node int-4 ne)
			(road-11 maint-1 int-4 nw)
			(road-12 int-3 int-1 n)
			(road-13 int-4 int-2 n))
	       
	       :sectors '((sector-1 (battle 
				     demand-2 
				     int-1
				     road-1 
				     road-2 
				     road-3))
			  (sector-2 (demand-1 
				     fuel-depot 
				     int-2
				     road-8
				     road-4 
				     road-5 
				     road-6))
			  (sector-3 (int-3 
				     sensor-node
				     road-7
				     road-9 
				     road-10 
				     road-12))
			  (sector-4 (maint-1 
				     int-4 
				     road-11 
				     road-13)))))
	    
	    (events '())
    
	  (world (make-world map events)))
    
    ;;; Install events that depend on the world already being defined

    ;; The sun goes up and down every 10 hours
    (install-exogenous-event
     (make-exogenous-event :time-period '(600) ; i.e. Days are 10 hours long
			   :set-properties `(,(world-sectors world)
					     nil
					     (daytime (PROB-COND
						       ((#'eq ((ARG 0) daytime) T)
							nil)
						       (T T)))))
     world)
    
;;;    ;; Sector 1 is moderately rainy
;;;    
    (install-exogenous-event
     (make-exogenous-event :time-period '((dist-mean-var 400 200) ; Time between
					  (dist-mean-var 100 50)) ; duration
			   :set-properties `((,(sector 'sector-1 world))
					     nil
					     (weather (PROB-COND
						       ((#'eq ((ARG 0) weather)
							      sunny)
							rainy)
						       (T sunny)))))
     world)
;;;
;;;    ;; Sector 2 rains a little

    (install-exogenous-event
     (make-exogenous-event :time-period '((dist-mean-var 1000 200) ; Time between
					 (dist-mean-var 100 50)) ; duration
			   :set-properties `((,(sector 'sector-2 world))
					     nil
					     (weather (PROB-COND
						       ((#'eq ((ARG 0) weather)
							      sunny)
							rainy)
						       (T sunny)))))
     world)
;;;
;;;    ;; Sector 3 is the olympic penninsula

    (install-exogenous-event
     (make-exogenous-event :time-period '((dist-mean-var 50 200) ; Time between
					 (dist-mean-var 100 50)) ; duration
			   :set-properties `((,(sector 'sector-3 world))
					     nil
					     (weather (PROB-COND
						       ((#'eq ((ARG 0) weather)
							      sunny)
							rainy)
						       (T sunny)))))
     world)

    ;; Sector 4 is Death valley: no rainstorm process

    ;; SHUFFLING event:  Every 100 time units, this event will check
    ;; the contents of the sensor node.  If it doesn't contain a truck,
    ;; then objects will magically move around.
    
    (install-exogenous-event
     (make-exogenous-event :time-period '(100)
			   :set-properties `((,(node 'sensor-node world))
					     nil
					     (jolt (PROB-COND
						    ((#'contains-truck ((ARG 0)
									contents) nil)
						     0)
						    (T 100)))))
     world)
    
    ;; Every 100 time units or so, enemies appear in battle, and the adjoining
    ;; roads, that hang around for 100 or so units.

    (install-exogenous-event
     (make-exogenous-event :time-period '((dist-mean-var 100 0))
			   :set-properties `((,(make-enemy-unit-maker
						(node-list '(battle) world)))

					     nil
					     (set (prob-dist
						   (0.5 (1 (dist-mean-var 100 100)))
						   (0.3 (2 (dist-mean-var 100 100)))
						   (0.2 (3 (dist-mean-var 100 100)))))))
     world)
    
    ;; Populate the world.
    
    (dotimes (x 5)
      (populate-world world (make-fuel-drum 5 10) 'fuel-depot))
    (populate-world world (make-sim-object 'liquid-sensor) 'fuel-depot)
    (dotimes (x 3)
      (populate-world world (make-fuel-drum 5 15) 'maint-1))
    
    ;;; SENSOR-NODE

    ;;; 2 red rocks
    (dotimes (x 2)
      (populate-world world (make-rock 5 'red) 'sensor-node))
    ;;; 2 green rocks
    (dotimes (x 2)
      (populate-world world (make-rock 5 'green) 'sensor-node))
    ;;; 3 fuel drums
    (dotimes (x 3)
      (populate-world world (make-fuel-drum 5 10) 'sensor-node))
    ;;; A color sensor
    (populate-world world (make-sim-object 'color-sensor) 'sensor-node)
    ;;; An innacurate color sensor
    (populate-world world (make-sim-object 'bad-color-sensor) 'sensor-node)
    ;;; A sonar (senses the existence of objects)
    (populate-world world (make-sim-object 'sonar) 'sensor-node)
    ;;; An x-ray machine (can see inside lead boxes)
    (populate-world world (make-sim-object 'x-ray-machine) 'sensor-node)
    ;;; A lead box with a rock in it
    (populate-world world (setf temp
			    (make-sim-object 'lead-box 'capacity 20))
		    'sensor-node)
    (put-in temp (make-rock 5 'magenta))
    ;;; A box (not soundproof)
    (populate-world world (setf temp
			    (make-sim-object 'box 'capacity 20))
		    'sensor-node)
    (put-in temp (make-rock 5 'blue))
    ;; A soundproof box (the sonar won't be able to see through it)
    ;; With a yellow rock in it
    (populate-world world (setf temp
			    (make-sim-object 'soundproof-box 'capacity 20))
		    'sensor-node)
    (put-in temp (make-rock 5 'yellow))
    
    (dotimes (x 2)
      (populate-world world (make-rock 15) 'battle))
    (dotimes (x 5)
      (populate-world world (make-fuel-drum 5 10) 'battle))
    (dotimes (x 2)
      (populate-world world (make-tire) 'maint-1))
    (dotimes (x 1)
      (populate-world world (make-weapon) 'demand-1))
    (dotimes (x 6)
      (populate-world world (make-ammo-box 2 10) 'demand-2))
    (populate-world world (make-winch) 'maint-1)
    
    
    world))



(defun contains-truck (clist couldnt-care-less)
  (find-if #'(lambda (x) (typep x 'truck)) clist))
