(defobject world (sim-object)
  (:slot clock :accessor clock
	 :initform nil)
  (:slot world-map :accessor world-map
	 :initform nil)
  (:slot exogenous-events :accessor exogenous-events
	 :initform nil))

(defvar *the-world* nil)

;;; CONSTRUCTORS **************************************************

(defun make-world (map events)
  (make-sim-object 'world
		   'world-map map
		   'exogenous-events events
		   'clock (make-controller 0)))

;;; OPERATIONS ************************************************************

;;;
;;; ACTUAL-TIME
;;; 
;;; Returns the simulator time for a given  world.  The default is
;;;  *the-world*.
;;;

(defun actual-time (&optional (world *the-world*))
  ;; This world-validity check is to guard against clock queries
  ;; before *the-world* has been fully initialized.
  (if (typep world 'world)
      (query (clock world) 'value)
    0))



(defun advance-world-time (world totime)
  (if (compare-times totime '> (value (clock *the-world*)))
      (setf (value (clock *the-world*)) totime)))


;;;
;;; POPULATE-WORLD world object location
;;;
;;; World is a world object.
;;; Object is some SIM-OBJECT
;;; Location is an id that identifies a node in the world
;;;
;;; The object is put-in the node named by location
;;;

(defun populate-world (world object location)
  (let ((node (find-if #'(lambda (n) (eq (query n 'id) location)) 
		       (nodes (world-map world)))))
    (cond
     (node
      (put-in node object))
     (t
      (cerror "Continue without placing object anywhere"
	      "~S does not name a node within ~S" location world)))))



      