(defobject vessel (thingoid)
  (capacity    0)
  (composition '())
  (amount-held 0 (:effect #'recompute-own-gross-bigness))
  (:slot spout-occupied :initform nil
	 :accessor spout-occupied))

;; (:set-properties #'myself (gross-bigness #'recompute-gross-bigness))))

;;; CONSTRUCTORS **************************************************

(defun make-vessel (bigness capacity)
  (let ((new-vessel (make-sim-object 'vessel
				     'bigness bigness
				     'capacity capacity)))
    new-vessel))


;;; DERIVED PROPERTIES **************************************************

;;;
;;; A vessel's gross bigness is its own bigness plus the amount of stuff
;;; inside it

(defmethod compute-gross-bigness ((self vessel))
  (+ (query self 'bigness) (query self 'amount-held)))


(defmethod space-full ((self t))
  0)

(defmethod space-full ((self vessel))
  (query self 'amount-held))

(defmethod space-empty ((self t))
  0)

(defmethod space-empty ((self vessel))
  (- (query self 'capacity) (query self 'amount-held)))


;;; OPERATIONS **************************************************

;;;
;;; POUR-IN vessel composition amount
;;;
;;; This increases the amount of stuff in a vessel by AMOUNT, up to
;;; the vessel's capacity.  The composition may be a symbol naming the
;;; kind of liquid being poured in, or a list of such symbols, describing
;;; the mixture of liquids being poured in.  The mixture in the container
;;; will be whatever was in there before, plus the stuff being poured in.
;;;
;;; If composition is NIL, then the composition of the vessel is unchanged.
;;;
;;; Pour-in returns the amount successfully poured in
;;;
;;; Example:  We have an empty gas tank (composition nil), whose capacity is
;;; 26:
;;;   (pour-in gas-tank 'gasoline 20) -> 20
;;;   (query gas-tank 'contents) -> (gasoline)
;;; Now we pour italian dressing into it
;;;   (pour-in gas-tank '(oil vinegar dijon-mustard) 10) -> 6
;;;   (query gas-tank 'contents) -> (gasoline oil vinegar dijon-mustard)
;;;

(defmethod pour-in ((self vessel) composition amount)
  (let ((comp (insure-list composition))
	poured)
    
    (setp self 'composition (union comp (query self 'composition)))
    (cond
     ((eq amount t)
      (setf poured (space-empty self))
      (setp self 'amount-held (query self 'capacity)))
      
     ((< amount (space-empty self))
      (setf poured amount)
      (setp self 'amount-held (+ amount (query self 'amount-held))))
     
     (t
      (setf poured (space-empty self))
      (setp self 'amount-held (query self 'capacity))))
    (unless *update-often*
      (update-displayers self))		;**UPDATE**
    poured))


(defmethod pour-in (not-a-vessel composition amount)
  0)

;;;
;;; POUR-PUT vessel amount
;;;
;;; This removes AMOUNT units of liquid from the vessel (up to the amount
;;; held in the vessel).  If no liquid remains in the vessel, the composition
;;; property becomes NIL.
;;; The amount actually poured is returned
;;;
;;; Example: We have the gas tank from above
;;;  (pour-out gas-tank 15)  -> 15
;;;  (query gas-tank 'composition) -> (gasoline oil vinegar dijon-mustard)
;;;  (pour-out gas-tank 15)  -> 11
;;;  (query gas-tank 'composition) -> NIL
;;;

(defmethod pour-out ((self vessel) amount)
  (let (poured)
    (cond
     ((eq amount t)
      (setf poured (query self 'amount-held))
      (setp self 'amount-held 0)
      (setp self 'composition nil))
     ((< amount (space-full self))
      (setf poured amount)
      (setp self 'amount-held (- (space-full self) amount)))
     (t
      (setf poured (query self 'amount-held))
      (setp self 'amount-held 0)
      (setp self 'composition nil)))
    (unless *update-often*
      (update-displayers self))		;**UPDATE**
    poured))

(defmethod pour-out (not-a-vessel amount)
  0)

   
    
