
;;;
;;; OBJECTS THE TRUCK NEEDS
;;;

;;;----------------------------------------------------------------------
;;;
;;; TIRES

(defparameter *tire-bigness* 20)

(defobject tires (thingoid)
  (bigness *tire-bigness*)
  (:slot mpg-adjust :initform 100	; % adjustment of truck's mpg
	 :accessor mpg-adjust)
  (:slot mph-adjust :initform 100	; % adjustment of truck's mph
	 :accessor mph-adjust)
  (:slot accident-adjust		; % adjustment of values in
	 :initform '(100 100 100)	; *ACCIDENT-PROBABILITIES* when worn
	 :accessor accident-adjust))
	 

(defobject mud-tires (tires)
  (:slot accident-adjust :initform *default-mud-tire-accident-adjust*)
  (:slot mph-adjust :initform *default-mud-tire-mph-adjust*)
  (:slot mpg-adjust :initform *default-mud-tire-mpg-adjust*))


(defun make-tire (&key (bigness *tire-bigness*))
  (let ((tire (make-sim-object 'tires)))
    (setp tire 'bigness bigness)
    tire))

;;;;;;;;;;;;;;;;;;
;;;
;;; Liquid sensors
;;;

(defsensor liquid-sensor
    :sensed-properties '(composition amount-held)
    :sensing-scope #'pointed-at-thing)

;;;;;;;;;;;;;;;;;;
;;;
;;; FUEL-DRUMS

(defobject fuel-drum (vessel)
  (bigness 5)
  (capacity 10))

(defun make-fuel-drum (bigness capacity &optional (fill-er-up t))
  (let ((drum (make-sim-object 'fuel-drum 
			       'bigness bigness 
			       'capacity capacity)))
    (if fill-er-up (pour-in drum 'gasoline capacity))
    drum))


;;;----------------------------------------------------------------------
;;;
;;; WEAPONS

(defparameter *weapon-bigness* 10)

(defobject weapon (vessel)
  (:slot set-duration :initform 0)
  (:slot shots-per-round :accessor shots-per-round
	 :initform 1)
  (:slot last-fired :accessor last-fired
	 :initform nil)
  (:slot accuracy :accessor accuracy
	 :initform '(prob-dist 
		     (70  t)
		     (30  nil)))
  (bigness *weapon-bigness*))

(defun make-weapon (&key (cap 50) (spr 1)  (acc '(prob-dist 
						  (0.7  t)
						  (0.3  nil))))
  (make-sim-object 'weapon
		   'capacity cap
		   'shots-per-round spr
		   'accuracy acc))

;;;
;;; SET-OBJECT
;;;
;;; When set, the standard weapon fires at the objects in the given
;;; positions.  If an object is hit, it is destroyed.
;;;

(defmethod set-object ((self weapon) setter &rest targets)
  (when (or (null (last-fired self)) (< (last-fired self) (actual-time)))
    (let ((ammo-left (if (equal (query self 'composition) `(ammo))
			 (space-full self)
		       0))
	  (node (my-node self)))
      (when (and (numberp (car targets)) (> ammo-left 0))
	(let* ((enemy (mapcar #'(lambda (p)
				  (nth-contents (my-node self) p))
			      targets)))
	  
	  (do ((shots-to-go (min ammo-left (shots-per-round self))
			    (- shots-to-go 1)))
	      ((or (<= shots-to-go 0) (null enemy)) t)
	    (when (process-probability (accuracy self))
	      (destroy-object (car enemy))
	      (setf enemy (cdr enemy)))
	    (pour-out self 1)))))
    (setf (last-fired self) (actual-time))))

;;;;;;;;;;;;;;;;;;
;;;
;;; AMMO-BOX

(defobject ammo-box (vessel)
  (bigness 5)
  (capacity 10))

(defun make-ammo-box (bigness capacity &optional (fill-er-up t))
  (let ((drum (make-sim-object 'ammo-box
			       'bigness bigness 
			       'capacity capacity)))
    (if fill-er-up (pour-in drum 'ammo capacity))
    drum))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; WINCH
;;;
;;; The winch, when set, can get the truck unstuck.
;;;

(defobject winch (thingoid)
  (bigness 20)
  (set-duration 5)
  (set-duration-noise '(dist-mean-var 0 2)))

(defun make-winch ()
  (make-sim-object 'winch))

(defmethod set-object ((self winch) setter &rest args)
  (when (and (typep setter 'truck) 
	     (member (truck-status setter) '(stuck rolled)))
    (setf (truck-status setter) 'happy)))

  
