

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; THINGOID
;;;

(defobject thingoid (sim-object)
  (kind       'thingoid)
  (material   'sim-stuff)
  (jolt       nil)
  (gross-bigness 0 (:effect #'recompute-containers-gross-bigness))
  (bigness       5 (:effect #'recompute-own-gross-bigness)))

;;;  (gross-bigness 0 (#'my-container 
;;;				    (gross-bigness #'recompute-gross-bigness)))
;;;  (bigness    0  (#'myself  
;;;				  (gross-bigness #'recompute-gross-bigness))))

(defmethod destroy-object ((self thingoid))
  (take-out (query self 'container) self))

    

;;;
;;; RECOMPUTE-GROSS-BIGNESS 
;;;
;;; This is used in figuring out how gross-big an object is when some relevant
;;; property is setp'ed.
;;;
;;; In the case where an object is computing its own gross bigness,
;;;    thing1 = thing2.
;;; If an object is changing its container's gross bigness,
;;;    thing2 = the container, so return the gross bigness of thing2
;;; See how containers work for more info.

(defun recompute-own-gross-bigness (thing old new)
  (setp thing 'gross-bigness (compute-gross-bigness thing)))

(defun recompute-containers-gross-bigness (thing old new)
  (let ((cont (query thing 'container)))
    (setp cont 'gross-bigness (compute-gross-bigness cont))))


(defmethod compute-gross-bigness ((self t))
  0)

(defmethod compute-gross-bigness ((self thingoid))
  (query self 'bigness))


;;;
;;; JOLT-OBJECT
;;;
;;; Sends the JOLT message down the containment hierarchy of an object
;;; the JOLT properties of each object can have side effects that do
;;; things, like break the object, or shuffle the contents.
;;;

(defun jolt-object (object intensity)
  (propagate-message-inside object 'g-force 'jolt intensity))

