
;;;
;;; SHUFFLE-CONTAINER
;;;
;;; This function is suitable for supplying as an :EFFECT side-effect
;;; function.  As such, it takes as arguments, the container,
;;; the old value of the property, and the new value of the property,
;;; which should be a number between 0 and 100, specifying the chance
;;; that a given object will move to a new position.
;;;

(defmethod shuffle-container ((self t) old-prob prob)
  nil)

(defmethod shuffle-container ((self container) old-prob prob)
  (when (numberp prob)
    (let ((pos-list nil)
	  (obj-list nil)
	  position)
      (dolist (obj (holdings self))
	(setf position (query obj 'position))
	(when (and (random-chance? prob) (take-out self obj))
	  (push position pos-list) 
	  (push obj obj-list)))
      (setf pos-list (sort pos-list #'< :key #'(lambda (x) (random 10.0))))
      (mapc #'(lambda (p o) (put-in-at-position self p o t))
	    pos-list obj-list))))

