;;
;; START-SERVER
;;
;; This initializes and starts the server.  See INITIALIZE-SIMULATOR
;; for arguments.
;;

(defun start-server (&rest keys)
  (apply #'initialize-simulator :allow-other-keys t keys)
  (format t "Truckworld server initialized.  Waiting for client connections~%")
  (server-loop))



;;
;; INITIALIZE-SIMULATOR
;;
;; Sets up a world, and initializes the simulator
;;

(defun initialize-simulator (&rest key-args 
			     &key (port 9997) sim-to-clock quantum world
			     &allow-other-keys)
  
  (format t "Opening connection to port~%")
  (initialize-ipc port)
  (format t "Initializing control structures~%")
  (initialize-control)
  (format t "Initializing realtime system~%")
  (initialize-realtime sim-to-clock quantum)
  (format t "Initializing world~%")
  (setf *stop-server* nil)
  (initialize-domain world))

;;
;; TERMINATE-SIMULATOR
;;
;; Terminates the simulation. All trucks are cleanly removed from the simulator
;; and the server shuts down.
;;

(defun terminate-simulator ()
  (format t "Disconnecting trucks...~%")
  (loop while *the-truck-table* do
    (shutdown-truck (first *the-truck-table*)))
  (stop-ipc)
  (stop-server))


;;;
;;; RUN-DEMO-SERVER
;;;
;;; starts the server up, specifying "multi-agent-world" as the
;;; world to run in.  It accepts all the keyword arguments that 
;;; initialize-simulator does (but not :world, obviously)
;;;

(defun run-demo-server (&rest keys)
  (apply #'start-server :world "multi-agent-world"
	 keys))



