;;;*********************************************************
;;;  Points and rectangles.  
;;;
;;;  A point is a list (x y)
;;;  A rectangle is a list (p1 p2) where p1 and p2 
;;;  are the upper left and lower right points in the 
;;;  rectangle
;;;

(defun make-point (&key x y)
  (list x y))

(defun point-x (point)
  (first point))

(defun point-y (point)
  (second point))

(defun add-point (point &key (x 0) (y 0))
  (make-point :x (+ (point-x point) x) :y (+ (point-y point) y)))

(defun add-points (p1 p2)
  (make-point :x  (+ (point-x p1) (point-x p2))
              :y  (+ (point-y p1) (point-y p2))))

;;;****************

(defun ->rectangle (x y w h)
  (make-rectangle :origin (make-point :x x :y y) :width w :height h))

(defun make-rectangle (&key origin other-point width height)
  (cond
   ((not origin) 
    (error "Not enough information to make a rectangle"))
   ((and other-point (or width height))
    (error "Too much information to make a rectangle"))
   (other-point 
    (list origin other-point))
   (t (list origin
            (make-point :x (+ width  (point-x origin))
                        :y (+ height (point-y origin)))))))

(defun rectangle-origin (rec)
  (first rec))

(defun rectangle-other-point (rec)
  (second rec))

(defun rectangle-width (rec)
  (- (point-x (rectangle-other-point rec))
     (point-x (rectangle-origin rec))))

(defun rectangle-height (rec)
  (- (point-y (rectangle-other-point rec))
     (point-y (rectangle-origin rec))))

(defun rectangle-min-x (rec)
  (point-x (rectangle-origin rec)))
(defun rectangle-min-y (rec)
  (point-y (rectangle-origin rec)))
(defun rectangle-max-x (rec)
  (point-x (rectangle-other-point rec)))
(defun rectangle-max-y (rec)
  (point-y (rectangle-other-point rec)))

(defun rectangle-center (rec)
  (make-point 
   :x (+ (point-x (rectangle-origin rec)) (truncate (rectangle-width rec) 2))
   :y (+ (point-y (rectangle-origin rec)) (truncate (rectangle-height rec) 2))))

(defun offset-rectangle (rec &key (x 0) (y 0) (width 0) (height 0))
  (let ((r-origin (rectangle-origin rec))
        (r-width (rectangle-width rec))
        (r-height (rectangle-height rec)))
    (make-rectangle :origin (add-point r-origin :x x :y y)
                    :width (+ width r-width)
                    :height (+ height r-height))))


