
(defvar *sim-to-clock-time* nil)
(defvar *sim-time-quantum* nil)

(let ((basetime nil))
  
  
;;;
;;; INITIALIZE-REALTIME ctst stq
;;;
;;; When the server is started, this function is called to start the
;;; simulator's real time clock.  CTST is a ratio of simulator time
;;; to wall time.  STQ is the size of the increment for simulator
;;; time.
;;;
;;; Examples: ctst = 1/10   stq = 1
;;;              Every 10 seconds, the simulator will advance by 1 time unit
;;;           ctst = 1/10   stq = 2
;;;              Every 20 seconds, the simulator will advance by 2 time units
;;;           ctst = 1/5    stq = 2
;;;              Every 10 seconds, the simulator will advance by 2 time units
  
  (defun initialize-realtime (ctst stq)
    (loop while (and ctst (or (not (integerp stq))
			      (<= stq 0)))
	do
	  (cerror "Enter an integer for time quantum"
		  "Non-positive time quantum for real-time conversion was given")
	  (format t "Enter a positive integer for time-quantum: ")
	  (setf stq (read)))
    (setf *sim-to-clock-time* ctst)
    (setf *sim-time-quantum* stq)
    (setf basetime nil))

;;;
;;; REAL-TIME-MODE?
;;;
;;; Returns whether or not the simulator is in real time mode
;;; (i.e. a NIL *sim-to-clock-time* or not)
;;;
  
  (defun real-time-mode? ()
    (not (null *sim-to-clock-time*)))
  
;;;
;;; REAL-TIME
;;;
;;; When called, returns what the current simulator time should be
;;; relative to the time at which INITIALIZE-REALTIME was called,
;;; and the parameters given it.
;;; Returns NIL if simulator is not in real-time mode
;;;
  
  (defun real-time ()
    (cond
     
     ;; If this is the first real-time call, and real-time is activated,
     ;; report 0 as the first time.
     
     ((and *sim-to-clock-time* (null basetime))
      (setf basetime (get-internal-real-time))
      0)
     
     ;; If real-time is activated, round to the nearest *sim-time-quantum*
     ;; since the simulation's beginning
     
     (*sim-to-clock-time*
      (* *sim-time-quantum*
	 (truncate (* (/ (- (get-internal-real-time) basetime) 
			 internal-time-units-per-second)
		      *sim-to-clock-time*)
		   *sim-time-quantum*)))

     ;; Else, real time is not activated, and we report NIL
     (t
      nil)))
  
  )
      
     
     
    