(defobject world-map (container)
  (:slot sectors :accessor sectors
	 :initform nil)
  (:slot links :accessor links
	 :initform nil)
  (:slot nodes :accessor nodes
	 :initform nil))


(defvar *map-name-table*)

;;; CONSTRUCTORS **************************************************


(defun make-map (&key (nodes   '())
		      (links   '())
		      (sectors '()))
  
  ;;; Note the order of creation: Nodes first,
  ;;;  Roads second (they look up the node names)
  ;;;  Sectors must be created last (they look up node and road names)

  (setf *map-name-table* (make-hash-table))
  (let* ((new-nodes (mapcar #'(lambda (r) (apply #'make-map-node r)) nodes))
	 (new-links (mapcar #'(lambda (r) (apply #'make-map-link r)) links))
	 (new-sectors (mapcar #'(lambda (r) (apply #'make-map-sector r)) sectors))
	 (new-map (make-sim-object 'world-map
				   'sectors new-sectors
				   'links   new-links
				   'nodes   new-nodes)))
    (mapcar #'(lambda (x) (put-in new-map x)) new-sectors)
    (consistency-check new-map)
    new-map))
				  

(defun consistency-check (map)
  (let ((phantoms nil))

    ;; Are all roads in sectors?
    (dolist (road (links map))
      (when (not (typep (query road 'container) 'map-sector))
	(push road phantoms)))

    ;; Are all nodes in sectors?
    (dolist (node (nodes map))
      (when (not (typep (query node 'container) 'map-sector))
	(push node phantoms)))

    (when phantoms
      (error "The following map items were not assigned to any sector: ~S"
	     phantoms))))

