



(defobject map-sector (container)
  ;;  (weather 'sunny (#'sector-links ((condition #'recompute-road-condition))))
  (weather 'sunny (:effect #'recompute-all-road-conditions))
  (daytime t)
  (:slot membership-test 
	 :initform #'(lambda (sector thing) (typep thing '(or map-link map-node)))))


(defmethod destroy-object ((self map-sector))
  nil)

;;; CONSTRUCTORS **************************************************


(defun make-map-sector (sector-name sector-components)
  (let ((new-sector (make-sim-object 'map-sector 'id sector-name)))
    (setf (gethash sector-name *map-name-table*) new-sector)
    (mapcar
     #'(lambda (name)
	 (let ((thing (gethash name *map-name-table*)))
	   (if (typep thing '(or map-link map-node))
	       (put-in new-sector thing)
	     (cerror "Ignore and continue"
		     "~S names no map link or map node" name))))
     sector-components)
    new-sector))


  
(defun recompute-all-road-conditions (sector old new)
  (mapc #'(lambda (road)
	    (recompute-road-condition sector road))
	(sector-links sector)))
