
(defobject map-node (container)
  (material 'node-stuff)
  (:slot map-roads 
	 :accessor map-roads
	 :initform (fill (make-array 8) nil))
  (:slot display-info
	 :accessor display-info
	 :initform nil))


;;; CONSTRUCTORS ;;;;

;;; When making a map node, enter it's name in the map symbol table,
;;; so that it can be referenced when creating it's sector

(defun make-map-node (node-name &key display-info)
  (let ((new-node (make-sim-object 'map-node
				   'id node-name
				   'display-info display-info
				   'max-positions *max-node-displayer-size*)))
    (setf (gethash node-name *map-name-table*) new-node)))


(defmethod destroy-object ((self map-node))
  nil)