(defobject map-link-subnode (map-node)
  (:slot milepost :accessor milepost
	 :initform nil))


;;; CONSTRUCTORS ************************************************ ;;;;


(defun make-map-link-subnode ()
  (let ((new-node (make-sim-object 'map-link-subnode)))
    new-node))



;; NODE-AT
;;
;; Given a road, and a mile marker along the road, return the node
;; that exists at that mile marker.  Mile 0 is the start node,
;; Mile (length link) is the finish node, and anything inbetween
;; is a sub-node (implicitly created and placed on the road if none existed
;; before).
;;

(defun node-at (link mile)
  
  (cond 
    ((<= mile 0) (start-node link))
    ((>= mile   (query link 'length)) (finish-node link))
    (t (let ((road-vector (sub-nodes link)))
	 (cond 
	  ((class? (svref road-vector mile) 'map-link-subnode)
	   (svref road-vector mile))
	  (t (let* ((new-node (make-map-link-subnode))
		    (node-roads (map-roads new-node)))
	       
	       ;; Hook the road up to the new subnode, and make signs
	       (put-in new-node 
		       (make-sim-object 'roadsign 
					'direction (direction link)))
	       (setf (svref (map-roads new-node)
			    (map-direction-index (direction link)))
		 (cons link (direction link)))
	       (put-in new-node 
		       (make-sim-object 'roadsign 
					'direction
					(map-direction-opposite 
					 (direction link))))
	       (setf (svref (map-roads new-node)
			    (map-direction-index 
			     (map-direction-opposite 
			      (direction link))))
		 (cons link 
		       (map-direction-opposite (direction link))))

	       ;; Set the position along the road
	       (setf (milepost new-node) mile)
	       (setf (svref road-vector mile) new-node)
	       (put-in link new-node)
	       new-node)))))))

;;; OPERATIONS ********************************************************;;;

;;
;; whenever a truck moves in to a a sub-node, the road displayer
;; must be updated, to get the road to highlight correctly.
;;

(defmethod put-in :after ((self map-link-subnode) (truck truck) 
			  &optional force-it)
  (update-displayers (query self 'container)))

;; TAKE-OUT map-link-subnode
;;
;; When all things are removed from a sub-node (objects rot, trucks drive off)
;; (except for roadsigns) then the sub-node disappears from the road it is on.
;;

(defmethod take-out :after ((self map-link-subnode) (truck truck))
  (let ((road (query self 'container)))
    (when (and (class? road 'map-link)
	       (every #'(lambda (x) (typep x 'roadsign))   (holdings self)))
      ;; Remove the roadsigns from the effects of the road's changes
      (setf (road-signs road) (nset-difference (road-signs road)
					       (holdings self)))
      (take-out road self)
      (setf (svref (sub-nodes road) (milepost self)) nil))
    (update-displayers (query self 'container));**UPDATE**
    ))
    
