;;; Functions for dealing with directions


(defun map-direction? (direction)
  (member direction '(n s w e ne nw se sw) :test #'eq))

(defun map-direction-opposite (direction)
  (cond ((eq direction 'e) 'w)
        ((eq direction 'ne) 'sw)
        ((eq direction 'n) 's)
        ((eq direction 'nw) 'se)
        ((eq direction 'w) 'e)
        ((eq direction 'sw) 'ne)
        ((eq direction 's) 'n)
        ((eq direction 'se) 'nw)
        (t nil)))

(defun map-direction-left (direction)
  (cond ((eq direction 'e) 'ne)
        ((eq direction 'ne) 'n)
        ((eq direction 'n) 'nw)
        ((eq direction 'nw) 'w)
        ((eq direction 'w) 'sw)
        ((eq direction 'sw) 's)
        ((eq direction 's) 'se)
        ((eq direction 'se) 'e)
        (t nil)))

(defun map-direction-right (direction)
  (cond ((eq direction 'e) 'se)
        ((eq direction 'ne) 'e)
        ((eq direction 'n) 'ne)
        ((eq direction 'nw) 'n)
        ((eq direction 'w) 'nw)
        ((eq direction 'sw) 'w)
        ((eq direction 's) 'sw)
        ((eq direction 'se) 's)
        (t nil)))

(defun map-direction-index (direction)
  (cond ((eq direction 'e) 0)
        ((eq direction 'ne) 1)
        ((eq direction 'n) 2)
        ((eq direction 'nw) 3)
        ((eq direction 'w) 4)
        ((eq direction 'sw) 5)
        ((eq direction 's) 6)
        ((eq direction 'se) 7)
        (t nil)))


;;; Constraints

(defun speed? (value)
  (member value '(stop slow medium fast) :test #'eq))


(defun bumpiness? (value)
  (member value '(low high) :test #'eq))

(defun status? (value)
  (member value
          '(happy stuck broken rolled captured dead)
          :test
          #'eq))

; --------------------------------------------------------------------
; * Random numbers, percentages and chances *
; -------------------------------------------

(defun random-number (n m)
  (let ((range (+ (- m n) 1)))
    (+ n (random range))))

(defun percent-adjust (percent value)
  (/ (* value percent) 100))

(defun random-chance? (percent)
  (>= percent (random-number 1 100)))

(defun random-chance-per? (chance delta interval)
  (cond ((null chance) nil)         ; ????
        ((<= chance 0) nil)
        ((>= chance 100) t)
        (t 
         (let ((percent (- 100
                           (truncate (* 100.0
                                        (exp (* (/ (coerce delta 'float)
                                                   (coerce interval 'float))
                                                (log (/ (coerce (- 100 chance) 'float)
                                                        100.0)))))))))
           (random-chance? percent)))))

(defun random-adjust (percent value)
  (/ (* value (random-number (- 100 percent) (+ 100 percent))) 100))


;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;
;;;
;;; Generating ID's
;;;

(let ((*id-counter* 0)
      (*this-package* *package*))
  
  (defun make-unique-id (prefix)
    (setf *id-counter* (1+ *id-counter*))
    (intern (concatenate 'string (string prefix) "-"
			 (princ-to-string *id-counter*)))))



