;;; ARM defaults

(defvar *default-arm-bigness* 50)
(defvar *default-arm-capacity* 50)
(defvar *default-arm-clumsiness* 100)
(defvar *default-arm-clumsiness-noise* 0)
(defvar *default-arm-speed* 1)
(defvar *default-arm-speed-noise* 0)
(defvar *default-arm-pour-duration* 0.2)
(defvar *default-arm-pour-duration-noise* 0)
(defvar *default-arm-grasp-duration* 2)
(defvar *default-arm-grasp-duration-noise* 0)
(defvar *default-arm-jolt-intensity* 50) ;When dropping an object,
					; specifies how hard to jolt the
					; object.  For containers,
					; this will specify what percentage
					; of the objects will get shuffled.
(defvar *default-arm-sensed-properties* '(POSITION BIGNESS))
					; The arm sensors will sense
					; these properties of each held
					; object.

;;; TRUCK defaults

(defvar *default-time-scale* 5)
(defvar *default-bay-capacity* 100)
(defvar *default-bay-bigness* 30)
(defvar *default-fuel-tank-capacity* 30)
(defvar *default-truck-mpg* 15)		; MPG at MEDIUM
(defvar *default-truck-mph* 0.25)	; MPH at MEDIUM
					; It takes 4 truck ticks to move one
					; unit of distance along a road.
					; (20 simulator ticks)
(defvar *default-slow-mpg-adjust* 150)	; % of medium MPG when going slow
(defvar *default-slow-mph-adjust* 50)	; % of medium MPH when going slow
(defvar *default-fast-mpg-adjust* 50)	; % of medium MPG when going fast
(defvar *default-fast-mph-adjust* 135)	; % of medium MPH when going fast
(defvar *default-truck-bigness* 1000)
(defvar *default-bumpy-jolt-intensity* 50) ; When traveling down a bumpy road,
					;  gives percentage of objects
					; in cargo bays which will bounce
					; around.
;; ROAD defaults

(defvar *default-link-bumpy* nil)
(defvar *default-link-fuel-drag* '(DIST-MEAN-VAR 95 25)) ; % applied to
					; truck's MPG 
(defvar *default-link-speed-drag* '(DIST-MEAN-VAR 95 25)) ; % applied to
					; truck's MPH
(defvar *default-link-length* 20)
(defvar *default-link-max-load* 5000)
(defvar *default-link-pavement* 'asphalt)


;;; This table defines how road conditions vary with weather and
;;;   road type.
;;;
;;;  WEATHER |      ROAD TYPE
;;;          | asphalt   dirt      gravel     -> good slippery muddy impassable
;;;  --------|-----------------------------
;;;  sunny   | good     slippery  slippery
;;;  rainy   | slippery muddy     slippery
;;;  stormy  | slippery impassable slippery
;;;


(defvar *road-condition-table*
    '((good     slippery   slippery)
      (slippery muddy      slippery)
      (slippery impassable slippery)))


;;; Table that defines the probabilities of NOT becoming XXX per 100 miles.
;;; (i.e. Making it 100 miles without XXX'ing)
;;; XXX is one of STUCK, ROLLED, DEAD, and the probabilites are listed
;;; in that order.  Note that these numbers are modified by the
;;; ACCIDENT-ADJUST slot of tire objects.
;;; Example: Truck moving FAST, on a MUDDY road:
;;;   50% of not getting stuck
;;;   60% of not rolling
;;;   60% of not dying
;;; Now we put on mud tires (accident-adjust = (110 100 100))
;;;   55% of not getting stuck
;;;   60% each of not rolling/dying

(defvar *accident-probabilities*
    '(
      (slow    
       (good 100 100 100) 
       (muddy 70 90 100)
       (slippery 90 90 100)
       (impassable 10 10 100))
      (medium  
       (good 100  100  100)
       (muddy 60 80 80) 
       (slippery 90 70 70)
       (impassable 10 10 10))
      (fast         
       (good 100  100  100) 
       (muddy 50 60 60)
       (slippery 90 40 40)
       (impassable 10 10 10))))

;; MUD-TIRE defaults

(defvar *default-mud-tire-accident-adjust* '(110 100 100))
					; This percentage vector
					; is applied to the vectors
					; in *accident-probabilities*
					; to compute actual probability
(defvar *default-mud-tire-mpg-adjust* 90) ; % Applied to truck's mpg
					; when traveling on road
(defvar *default-mud-tire-mph-adjust* 90) ; % Applied to truck's mph

;; NIGHT travel

(defvar *default-night-accident-adjust* '(85 100 90))
					; applied to accident
					; probabilities when traveling
					; at night.

;; Normal SENSOR defaults

(defvar *default-sensed-properties* 
    '(position kind size truck-id sensor-id direction condition length bumpy))
(defvar *default-sensing-method* 'visible-light)
(defvar *default-sensing-scope*	#'my-vicinity-neighbors)
(defvar *default-sensing-duration* 1)
(defvar *default-sensing-duration-noise* 0)

;; ACTIVE SENSOR DEFAULTS
;; The default active sensor is a motion-detector: it generates
;; reports whenever objects move in, out, or around the sensor's own vicinity
;; (which means the sensor's container, or the container it's gripping arm
;; is in).

(defvar *default-watched-objects* #'my-vicinity)
(defvar *default-watched-properties* '(contents))


