;;
;; SEND-COMMAND (truck)
;;
;; COMMAND is packaged and written to the command stream of a truck

(defmethod send-command ((truck truck) command)
  (send-command (channel truck) command)
  (stop-simulator)
  (setf (advance-clock truck) nil))


;;
;; SEND-CONTROL
;;
;; CONTROL is packaged and written over the control stream of a truck
;;

(defmethod send-control ((truck truck) control)
  (send-control (channel truck) control)
  (stop-simulator)
  (setf (advance-clock truck) nil))


(defmethod read-command ((truck truck))
  (read-command (channel truck)))

(defmethod command-message-available? ((truck truck))
  (command-message-available? (channel truck)))

(defmethod read-control ((truck truck))
  (read-control (channel truck)))

(defmethod control-message-available? ((truck truck))
  (control-message-available? (channel truck)))

(defmethod any-message-available? ((truck truck))
  (any-message-available? (channel truck)))


;;;;;

(defmethod send-control (thing control)
  nil)

(defmethod read-command (thing)
  nil)

(defmethod command-message-available? (thing)
  nil)


(defmethod read-control (thing)
  nil)

(defmethod control-message-available? (thing)
  nil)

(defmethod any-message-available? (thing)
  nil)


