
(defun find-sensor (truck sensor-name)
  (find-if #'(lambda (sensor)
	       (eq (query sensor 'id) sensor-name))
	   (built-in-sensors truck)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; TRUCK-READ sensor-name
;;;
;;; duration: 0
;;; Preconds: The sensor-name must name one of the sensors installed
;;;           in the truck
;;; effect  : read the descriptors from the named truck sensor, and
;;;           send them over the command channel of the truck in the form:
;;;           (SENSOR sensor-name descriptors)
;;;

(defun truck-read-command (truck sensor-name)
  (let ((sensor (find-sensor truck sensor-name)))
    (cond
     (sensor
      (values
       nil
       nil
       #'(lambda (tok time why)		; This is the process' update function
	   (send-command truck `(SENSOR ,sensor-name ,(read-object sensor)))
	   (stop-process tok))))
     (t
      (values 'NO-SUCH-SENSOR nil nil)))))
       
(install-command 'TRUCK-READ '(1) nil #'truck-read-command)
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; TRUCK-SET sensor-name
;;;
;;; duration: 0
;;; Preconds: The sensor-name must name one of the sensors installed
;;;           in the truck
;;; effect  : Activates the named sensor. Note that a sensor may take
;;;           some time to complete sensing.
;;;

(defun truck-set-command (truck sensor-name)
  (let ((sensor (find-sensor truck sensor-name)))
    (cond
     (sensor
      (values
       nil
       nil
       #'(lambda (tok time why)
	   (init-set-object sensor truck)
	   (stop-process tok))))
     (t
      (values 'NO-SUCH-SENSOR nil nil)))))


(install-command 'TRUCK-SET '(1) nil #'truck-set-command)

