;;;;
;;;; Server-side code to establish TCP connection
;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Pseudocode for how things should work
;;;

(defun pseudo-truckworld ()
  (unwind-protect
      (progn
	(initialize-ipc *port*)

	;; This is the Truckworld main loop
	(loop

	  ;; Get new connection, if any
	  (let ((new-channel (accept-client-connection)))
	    (when new-channel
	      (initialize-new-truck new-channel)))

	  ;; Do other stuff in the main loop
	  (process-commands-etc)))
    
    ;; When done, stop connection manager
    (IPC:stop-connection-manager)
    ;; Close all trucks' channels, too
    (close-all-truck-channels)
    ))

;;;
;;; End Of Pseudocode
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defvar *connection-port* nil)


;;;;;;;;;;;;;;;;;;;
;;;
;;; INITIALIZE-IPC port
;;;
;;; This sets up the system to accept client connections over a port.
;;; If PORT is nil, then the system is configured (as far as the ipc code
;;; is concerned) to run without using ipc communication
;;;

(defun initialize-ipc (port)
  (setf *connection-port* port)
  (when port
    (IPC:stop-connection-manager)
    (IPC:start-connection-manager port)))

;;;
;;; STOP-IPC
;;;
;;; This shuts down the IPC system.  If the system was never started,
;;; nothing is done.
;;;

(defun stop-ipc ()
  (when *connection-port*
    (format t "Stopping connection manager~%")
    (IPC:stop-connection-manager))
  (setf *connection-port* nil))

;;;
;;; ACCEPT-CLIENT-CONNECTION
;;;
;;; If a client is trying to connect to the server over the port specified
;;; in INTIAIZLIE-IPC, it will be accepted, and a CHANNEL object will
;;; be returned for communication with the client.  Otherwise
;;; returns NIL.
;;;
;;; When the system is not running under the IPC model, this always
;;; returns NIL
;;;

(defun accept-client-connection ()
  (when *connection-port*
    (let ((io-stream (IPC:accept-connection))
	  (channel nil))
      (when io-stream
	(setf channel (make-instance 'channel))
	(setf (io-stream channel) io-stream))
      channel)))


