;;;;
;;;; Client-side code to establish TCP connection
;;;;

;;;
;;; Connect to the Truckworld server running on the specified host and port.
;;; Return the command/control channel.
;;; If there is no host or port, then we are not opening a network
;;; connection, but trying to run locally
;;;

(defun connect-to-server (host port)
  (let* ((stream (if (and host port)
		     (IPC:open-network-stream :host host :port port)
		   nil))
	 (channel (make-instance 'channel)))
    (setf (io-stream channel) stream)
    channel))
