
;;;
;;; MICROPHONE is an active sensor that reports when it hears a sound.
;;;
;;; It waits for its own SOUND property to change, then reports
;;; the SOUND property of itself.

(defasensor microphone
    :extra-properties ((sound nil))
    :watched-objects #'myself
    :watched-properties '(sound)
    :sensing-scope  #'myself
    :sensed-properties '(sound))

;;;
;;; TAPE-RECORDER is a recording sensor that records everything it hears
;;; when on.
;;;

(defrsensor tape-recorder
    :extra-properties ((sound nil))
    :watched-objects #'myself
    :watched-properties '(sound)
    :sensing-scope  #'myself
    :sensed-properties '(sound))

;;;
;;; object SOUNDPROOF-BOX
;;;
;;; A soundproof box is a container made out of stuff that doesn't let
;;; sound through.
;;;

(defobject soundproof-box (container)
  (material 'sound-deadener)
  (capacity 10))


;;;
;;; object LOUDSPEAKER
;;;
;;; When set, it broadcasts its SET arguments to the SOUND property of any
;;; object visible by the SOUND medium. (hence, will set off any
;;; microphones in the map node).
;;;

;;; Sound can go through sim-stuff, but nothing else.

(def-sensing-method 'sound :transparent '(sim-stuff truck-stuff))

;;; A LOUDSPEAKER is an object that makes sounds

(defobject loudspeaker (thingoid))

;;; When SET (either through an explicit ARM-SET, an object's side-effect,
;;; or an exogenous event), the loudspeaker  broadcasts the list of arguments
;;; into the SOUND property of all objects that are visible through the 
;;; SOUND method of sensing.
;;; When ARM-SET, the SETTER argument will be the truck who performed
;;; the set, NIL otherwise.

(defmethod set-object ((self loudspeaker) setter &rest args)
  (broadcast-message self 'sound 'sound args))


