;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Radiation, uranium, lead boxes, radiation sensors
;;;

;;;
;;; Uranium is radioactive, as it's radioactive property says
;;;

(defobject uranium (thingoid)
  (radioactive t))

;;;
;;; Lead boxes are made of lead
;;;
;;; The MATERIAL property is common to all simulator objects, and defaults
;;; to SIM-STUFF.

(defobject lead-box (container)
  (material 'lead))

;;;
;;; Radiation can't go through lead
;;;

(def-sensing-method 'radiation :opaque '(lead))

;;;
;;; RADIATION-SENSOR can see radioactive objects when set
;;; (or more exactly, reports the RADIOACTIVE property of visible objects,
;;;  and their positions)

(defsensor radiation-sensor 
    :sensing-method 'radiation
    :sensed-properties '(position radioactive))


;;;
;;; X-RAY-MACHINE is a sensor that can see objects inside lead
;;; boxes
;;;

(def-sensing-method 'x-ray :opaque '(lead))

(defsensor x-ray-machine
    :sensing-method 'x-ray
    :sensed-properties '(position kind bigness))
