
;;;
;;; SONAR
;;;
;;; A sonar sensor detects objects around it, visible to SOUND,
;;; and reports position.
;;;

(defsensor sonar
    :sensing-scope #'my-vicinity-neighbors
    :sensed-properties '(position)
    :sensing-method 'ultrasonic-sound)

(def-sensing-method 'ultrasonic-sound :opaque '(sound-deadener truck-stuff))

;;;
;;; Color, by default, is sensed accurately 80% of the time,
;;; and off by one the other 20%
;;;

(defproperty 'color
    :enumeration '(BLACK PINK RED BROWN ORANGE YELLOW LIME GREEN CYAN BLUE
		   MAGENTA INDIGO 
		   VIOLET WHITE)
    :distortion '(prob-dist
		  (0.8 0)
		  (0.1 -1)
		  (0.1 1)))

;;;
;;; Color sensors sense color with the default accuracty for colors
;;;

(defsensor color-sensor
    :sensing-scope #'my-vicinity-neighbors
    :sensed-properties '(position color)
    :sensing-method 'visible-light
    :sensing-duration 5)

;;;
;;; The bad color sensor senses color poorly.
;;; The colors it reports are distributed under a normal curve,
;;; with the mean being the actual color, and 7 colors away being
;;; the variance.
;;;

(defsensor bad-color-sensor
    :parent-sensor color-sensor
    :sensed-properties '(position (color (dist-mean-var 0 7)))
    :sensing-duration 1)


;;;****************************

;;; TRANSPORTER
;;;
;;; SET <name>  -> moves the setting truck to the named map node.
;;;

(defobject transporter (thingoid)
  ())

(defmethod set-object ((self transporter) setter &rest args)
  (let ((node (node (first args))))
    (when (and (typep setter 'truck) node)
      (put-in node setter))))
