
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; object BOMB
;;;
;;; A BOMB is an item that when set, destroys things in the same map node.
;;; Note that SET-DURATION can be set to simulate a time-delay fuse
;;; when the bomb gets ARM-SET.
;;;
;;; The SET-DURATION only applies when ARM-SET is the operation that
;;; causes the SET to take place.  For other causes for SET (exogenous events,
;;; or side-effects), the SET takes place immediately.


(defobject bomb (thingoid)
  (effectiveness 100)
  (detonator nil (:destroy-objects #'random-bomb-victims)))

(defun make-bomb (&key (effectiveness 100) (fuse-delay 0))
  (make-sim-object 'bomb 'effectiveness effectiveness 'set-duration fuse-delay))

(defmethod set-object ((self bomb) setter &rest args)
  (setp self 'detonator t))

(defun random-bomb-victims (bomb)
  ;; This chooses random objects to destroy: certainly, the bomb itself
  ;; will be destroyed
  (cons bomb
	(remove-if-not #'(lambda (x)
			   (random-chance? (query bomb 'effectiveness)))
		       (my-node-neighbors bomb))))

	
  