;;;*********************************************************
;;;  Top-level calls to the displayer interface:
;;;      (MAKE-DISPLAYER truck world display-name &optional x y) => nothing
;;;      (TERMINATE-DISPLAYER-FOR-TRUCK truck)
;;;      (UPDATE-DISPLAYERS object)
;;;

(defvar *displayer-max-x*  689)
;;;  Max Y now decided by the height of the map
;;;  (defvar *displayer-max-y*  725)   

(defvar *displayer-list* '())

;;;************************************************************

(defun make-displayer (truck 
                       world 
                       time-controller
                       display-name 
                       &optional (origin (make-point :x 0 :y 0)))
  (let ((displayer (make-truck-displayer truck 
                                         world 
                                         time-controller
                                         display-name 
                                         origin)))
    (draw displayer)
    (setf *displayer-list* (cons displayer *displayer-list*))
    displayer))

(defun terminate-displayer-for-truck (truck)
  (let ((displayer (displayer-for-truck truck)))
    (terminate displayer)
    (setf *displayer-list* (delete displayer *displayer-list*))
    (values)))

(defun displayer-for-truck (truck)
  (find-if #'(lambda (d) (eq truck (td-truck d))) *displayer-list*))

(defun update-displayers (object-to-update)
  (when (not (null object-to-update))
    (mapc #'(lambda (disp) (update-display disp object-to-update))
          *displayer-list*)))

;;;************************************************************
;;;  This is called internally when something is in an inconsistent 
;;;  state.  Should be preferable to really signalling an error????
;;;  But shouldn't ever happen!

;;;(defun displayer-warning (fmt-string &rest args)
;;;  (apply #'format (cons *terminal-io* (append (list fmt-string) args))))

(defun displayer-warning (fmt-string &rest args)
  (declare (ignore fmt-string args))
  T)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;
;;; The simulator needs to know some things about the physics of the
;;; displayer.  Namely, maximum sizes of various bays.  Here they are:
;;;

(defvar *max-bay-displayer-size*        9)
(defvar *max-arm-displayer-size*        8)
(defvar *max-tire-bay-displayer-size*   1)
(defvar *max-weapon-bay-displayer-size* 1)
(defvar *max-node-displayer-size*       18)
