(defmethod display-gripper ((self bay-displayer) arm-displayer container position)
  (let* ((inside-outside NIL)
         (orientation NIL)
         (real-position
          (cond
           ((eq container (bay-displayer-displayed-object self))
            (setf inside-outside :OUTSIDE)
            (if (> position (bay-displayer-num-positions self)) 0 position))
           (t (setf inside-outside :INSIDE)
              (position-if #'(lambda (c) 
                               (or (eq c container)
                                   (contains-object c container)))
                           (bay-displayer-displayed-objects self))))))
    (cond 
     ((null real-position) NIL)
     (t (let ((current-gripper-displays 
               (remove-if-not #'(lambda (gd) (= real-position (second gd)))
                              (bay-displayer-gripper-data self))))
          (cond
           ((= 0 (length current-gripper-displays))
            (setf orientation :LEFT))
           ((= 1 (length current-gripper-displays))
            (let ((current-orientation (third (car current-gripper-displays))))
              (setf orientation 
                (if (eq current-orientation :BOTTOM)
                    :LEFT
                    :BOTTOM))))
           (t (displayer-warning "Too many grippers displayed at ~a" self)))
          (let ((point (bay-displayer-gripper-coords self 
                                                      real-position 
                                                      orientation)))
            (arm-displayer-draw-gripper arm-displayer 
                                        point 
                                        orientation 
                                        inside-outside)
            (push (list arm-displayer real-position orientation inside-outside)
                  (bay-displayer-gripper-data self))
            t))))))
