;;;
;;; Methods for all displayers:
;;;    (displayed-object self)
;;;    (update-display self object)
;;;    (draw self)
;;;    (terminate self)
;;;    (display-info-for-arm self object)
;;;    (display-region self)

(defmethod displayed-object (self)
  (declare (ignore self))
  nil)

(defmethod draw (self) 
  (declare (ignore self)) 
  nil)

(defmethod erase (self) 
  (disp.with-erasure (draw self)))

(defmethod redraw (self) 
  (erase self)
  (draw self))

(defmethod display-region (self)
  (declare (ignore self))
  (list 0 0 0 0))

(defmethod terminate (self) 
  (declare (ignore self)) 
  nil)

(defmethod update-display (self object)
  (displayer-warning "Call to update-display fell through ~a ~a~%" self object)
  nil)
  
;;;  Displaying/undisplaying grippers.  Only bay displayers really 
;;;  respond.  The truck passes it down.

(defmethod display-gripper (self arm container position)
  (displayer-warning "Bad call to display-gripper, with ~a ~a ~a ~a~%"
                     self arm container position)
  NIL)

(defmethod undisplay-gripper (self arm)
  (displayer-warning "Bad call to undisplay-gripper, with ~a ~a~%"
                     self arm)
  NIL)

