;;;*****************************************************
;;;  A location displayer acts pretty much like a bay 
;;;  except the container (map node) it displays can 
;;;  change, so it has to respond to set-containment
;;;  and unset-containment as well.   
;;;
;;;  At some point we might also want to make this displayer
;;;  smarter, so things like roadsigns don't display as 
;;;  everyday objects in the world.

(defstruct (loc-displayer (:print-function print-loc-displayer)
                          (:constructor really-make-loc-displayer))
  displayed-object
  display-region 
  rows 
  cols
  bay-displayer)

(defun print-loc-displayer (self stream depth)
  (declare (ignore depth))
  (format stream "{Loc displayer for ~a}" (loc-displayer-displayed-object self)))

(defvar *single-column-width* 50)
(defvar *single-row-height* 50)

(defun make-loc-displayer (point rows cols)
  (really-make-loc-displayer 
   :bay-displayer NIL
   :display-region (make-rectangle :origin point 
                                   :width (* cols *single-column-width*)
                                   :height (* rows *single-row-height*))
   :rows rows
   :cols cols))

;;;**********************************************************
;;;  Two things I especially have to do is set and unset the 
;;;  node I'm containing.

(defun loc-displayer-set-containment (self node)
  (let ((bd (make-bay-displayer 
             node
             NIL
             (rectangle-origin (loc-displayer-display-region self))
             (loc-displayer-rows self)
             (loc-displayer-cols self)
             '(top left) 
             'vertical)))
    (draw bd)
    (setf (loc-displayer-bay-displayer self) bd)
    (setf (loc-displayer-displayed-object self) node)))

(defun loc-displayer-unset-containment (self)
  (erase (loc-displayer-bay-displayer self))
  (setf (loc-displayer-bay-displayer self) NIL))
                        
;;;**********************************************************
;;; All methods get passed through to my displayer, if I have 
;;; one.

(defmethod displayed-object ((self loc-displayer))
  (when (loc-displayer-bay-displayer self)
    (displayed-object (loc-displayer-bay-displayer self))))

(defmethod draw ((self loc-displayer))
  (when (loc-displayer-bay-displayer self)
    (draw (loc-displayer-bay-displayer self))))

(defmethod display-region ((self loc-displayer))
  (cond 
   ((loc-displayer-bay-displayer self)
    (display-region (loc-displayer-bay-displayer self)))
   (t (loc-displayer-display-region self))))

(defmethod redraw ((self loc-displayer))
  (when (loc-displayer-bay-displayer self)
    (redraw (loc-displayer-bay-displayer self))))

(defmethod update-display ((self loc-displayer) object)
  (when (loc-displayer-bay-displayer self)
    (update-display (loc-displayer-bay-displayer self) object)))

(defmethod display-gripper ((self loc-displayer) ad c p)
  (when (loc-displayer-bay-displayer self)
    (display-gripper (loc-displayer-bay-displayer self) ad c p)))

(defmethod undisplay-gripper ((self loc-displayer) arm)
  (when (loc-displayer-bay-displayer self)
    (undisplay-gripper (loc-displayer-bay-displayer self) arm)))

