(defun draw-object-as-icon (obj rect)
  (let ((print-string (symbol-name 
                       (if (typep obj 'truck) 
                          (query obj 'truck-id)
                          (query obj 'kind)))))
    (disp.draw-3d-rectangle :up rect)
    (draw-bitmap obj rect)
    (disp.with-clip-window rect
      (disp.with-font (disp.tiny-font)
        (disp.draw-text print-string
                        (make-point :x (truncate (rectangle-width rect) 2)
                                    :y (- (rectangle-height rect) 2))
                        :bottom 
                        :center)))))

(defmethod draw-bitmap (obj rect)
  (let* ((bp (disp.fetch-bitmap (bitmap-pathname obj))))
    (cond
     (bp  (disp.draw-bitmap-with-name bp rect))
     (t (let ((kind (query obj 'kind)))
          (disp.with-font (disp.tiny-font)
            (disp.draw-text (symbol-name kind) 
                            (rectangle-center rect) 
                            :center)))))))

