;; TOKEN-TABLE.LISP
;;
;; DEFINES:
;;   class     token-table
;;   methods   insert-token
;;             remove-token
;;             lookup-token
;;   functions new-token

(deftype token () 'symbol)

(defclass token-table ()
  ((table  :accessor table
	   :initform (make-hash-table))))

(defvar *the-token-table* (make-instance 'token-table))

;;**********************************************************************
;;
;; METHODS
;;

;;
;; INSERT-TOKEN
;;
;;   Adds a token and it's associated information in the token-table.
;; An error is flagged if the token is already in the table.
;;

(defmethod insert-token ((self token-table) token object)
  (let ((foo (gethash token (table self))))
    (when foo
	(cerror "Set new value of token and continue"
		"Token ~S for ~S already in table" token foo))
    (setf (gethash token (table self)) object)))

;;
;; REMOVE-TOKEN
;;
;;   Removes a token from the table
;; An error is flagged if the token doesn't exist, and ignore-error is NIL
;;

(defmethod remove-token ((self token-table) token &optional (ignore-error t))
  (unless (or (remhash token (table self)) ignore-error)
    (cerror "Continue anyway"
	    "No token ~S exists in the table" token)))

;;
;; LOOKUP-TOKEN
;;
;;   Returns the object associated with a token.
;; If ignore-error is NIL, an error is flagged when the token isn't in
;; the table
;;

(defmethod lookup-token ((self token-table) token
			 &optional (ignore-error t))
  (let ((value (gethash token (table self))))
    (if (or value ignore-error)
	value
	(cerror "Return NIL as token value"
		"Token ~S doesn't exist in the table" token))
    value))



;;
;; NEW-TOKEN
;;
;;  Returns a unique token, prefixed with an optional string
;;

(defun new-token (&optional (prefix nil exists))
  (if exists
      (gentemp prefix)
      (gentemp)))

