;; SUPPORT.LISP
;;
;; DEFINES:
;;   functions: compare-numbers
;;              compare-times
;;
;; BUGS:
;;   None

;;**********************************************************************


(defun time->number (time)
  (if (numberp time)
      time
    (+ (* (car time) 1440) (+ (* (cadr time) 60) (caddr time)))))

(defun number->time (amount)
  (if (listp amount)
      amount
    (let* ((days (/ amount 1440))
	   (hours (/ (- amount (* days 1440)) 60))
	   (minutes (- amount (+ (* days 1440) (* hours 60)))))
      (list days hours minutes))))
    
(deftype sim-time () '(or number cons))

;;
;; COMPARE_NUMBERS compares 2 numbers, and returns <, >, or =
;;  according to the result of the comparison

(defun compare-numbers (n1 comp n2)
  (funcall comp n1 n2))

;;
;; COMPARE_TIMES compares 2 times, and returns <, >, or =
;;   according to the result of the comparison

(defmethod compare-times ((time1 number) comp (time2 number))
  (compare-numbers time1 comp time2))

(defmethod compare-times ((time1 cons) comp (time2 number))
  (compare-numbers (time->number time1) comp time2))

(defmethod compare-times ((time1 number) comp (time2 cons))
  (compare-numbers time1 comp (time->number time2)))

(defmethod compare-times ((time1 cons) comp (time2 cons))
  (compare-numbers (time->number time1) comp (time->number time2)))

;;
;; ADD_TIMES adds 2 times
;;

(defmethod add-times ((time1 cons) time2)
  (add-times (time->number time1) time2))

(defmethod add-times (time1 (time2 cons))
  (add-times time1 (time->number time2)))

(defmethod add-times ((time1 number) (time2 number))
  (+ time1 time2))

;;
;; SUB_TIMES subtracts times
;;

(defmethod sub-times ((time1 cons) time2)
  (sub-times (time->number time1) time2))

(defmethod sub-times (time1 (time2 cons))
  (sub-times time1 (time->number time2)))

(defmethod sub-times ((time1 number) (time2 number))
  (- time1 time2))




;;***********************************************************

(defun flush-queues ()
  (setf (events *the-event-queue*) nil)
  (setf *the-process-queue* nil)
  (setf (handlers *the-handler-queue*) nil))
