;; PROCESS-DEF.LISP
;;
;; DEFINES:
;;   class      process
;;
;; BUGS:
;;   Untested

;;**********************************************************************
;;
;; PROCESS class definition
;;


(defclass process
    ()
    ((active     :accessor active	; Is the process currently active?
		 :initform nil)
     (input      :accessor conditions	; List of conditions on which handlers
		 :initform nil)		;  should be invoked when they change
     (output     :accessor output	; List of conditions that the process
		 :initform nil)		; affects
     (token      :reader   token	; Unique Identifying token.
		 :initarg  token)
     (last-advanced			; The last sim-time the process
      :accessor last-advanced		; was ADVANCEd
      :initform nil)
     (update-function     
      :accessor update-function		; The update function for this process
      :initarg  update)))


(defvar *the-process-queue* '())	; List of currently active processes


;;;
;;; MAINTAINANCE-CONDITION
;;;
;;; This structure contains information that links processes to the world
;;; state.  Originally, this information was only used to define
;;; maintainance-conditions (input state) for a process.
;;; That is, changes in world state that affect the execution of the process.
;;; But later, it was also found to be useful for describing output state
;;; of a process, output state being the world state that the process
;;; affects.
;;;

(defclass maintainance-condition 
    ()
    ((proc     :accessor proc		; process m.c. belongs to
	       :initarg :proc)
     (object   :accessor object		; object of m.c.
	       :initarg :object)
     (property :accessor property	; property of m.c.
	       :initarg :property)
     (name     :accessor name		; m.c.'s name, assigned by the process
	       :initarg :name)
     (inout    :accessor inout		; An OUTPUT or INPUT condition?
	       :initarg :inout)
     (enable   :accessor enable		; enabled/disabled state
	       :initarg :enable)
     (marker   :accessor marker		; Marker for use in graph traversal
	       :initform nil)
     (prop-entry :accessor prop-entry))) ; The object-property object,
					; for fast lookup
