;; HANDLER-QUEUE.LISP
;;

(defclass handler-queue ()
  ((handlers    :accessor handlers
		:initform '())))

(defvar *the-handler-queue* (make-instance 'handler-queue)
  "Global condition handler queue")

;;**********************************************************************
;;
;; METHODS
;;

;;
;; ENQUEUE-HANDLER
;;
;;   Places a handler-info at the end of the queue
;;

(defun enqueue-handler (self call)
  (setf (handlers self) (nconc (handlers self) (list call))))

;;
;; DEQUEUE-HANDLER
;;
;;   Removes and returns the handler at the beginning of the queue
;;

(defun dequeue-handler (self)
  (prog1  (first (handlers self))
    (setf (handlers self) (rest (handlers self)))))

;;
;; EXECUTE-ALL-HANDLERS
;;
;;   Dequeues and executes all handlers in queue
;;

(defun execute-all-handlers (self)
  (do () ((null (handlers self)) t)
    (execute-handler (dequeue-handler self))))

;;
;; PRINT-OBJECT
;;
;;  So we can see the queue
;;

(defmethod print-object ((self handler-queue) out)
  (format out "<HQUEUE:~S>" (handlers self)))
