;; EVENT.LISP
;;
;; DEFINES:
;;   class      event
;;   functions: execute-event
;;              execute-action
;; BUGS:
;;   None

;;**********************************************************************
;;
;; EVENT class
;;

(defclass event ()
  ((time-when :accessor time-when     ; When event is to occurr
	      :initarg  time-when)
   (action    :accessor action        ; form to evaluate to implement event
	      :initarg  action)
   (token     :accessor token
	      :initarg  token)        ; unique token for this event
   (in-queue? :accessor in-queue?     ; Is this event in a queue?
              :initform nil))


  (:default-initargs time-when '(0 0 0) action nil
		     token (new-token)))


;;************************************************************
;; METHODS
;;

;;
;; EXECUTE-EVENT
;;
;; Executes the action associated with an event.
;;

(defmethod execute-event ((self event))
  (if (action self)
      (execution-context `(:EVENT ,self)
	  (funcall (action self) (token self) (time-when self)))))

;;
;; PRINT-OBJECT, so the event can be nicely printed
;;

(defmethod print-object ((self event) out)
  (format out "<EVENT:~S:~S>" (time-when self) (action self)))

;;
;; MAKE-EVENT
;;
;; This is just a nice function to aid in making events.
;;

(defun make-event (time-when action &key (token (new-token)))
  (make-instance 'event 'time-when time-when 'action action 'token token))






