
;;*********************************************************************

(defun start-client (&rest keys)
  (unwind-protect 
      (apply #'initialize-client keys)
    (progn (format t "(Closing client channel)~%")
           (close-channel *client-truck-channel*))))

(defvar *client-truck-channel* nil)


(defun initialize-client (&key host (port 9997) client
			       (truck-form '(make-truck))
			       truck-init-position display &allow-other-keys)
  (initialize-command-processor host port truck-form display
				truck-init-position)
  (if (functionp client)
      (funcall client *client-truck-channel*)))



(defun initialize-command-processor (host port truck-form display init-position)
  (setf *client-truck-channel* (connect-to-server host port))
  (setf *give-control-to-server* nil)
  (send-control *client-truck-channel* truck-form)
  (send-control *client-truck-channel* init-position)
  (setf *give-control-to-server* t)
  (send-control *client-truck-channel* display))

;;;
;;; *GIVE-CONTROL-TO-SERVER* is a flag that is only has meaning if
;;; the integrated simulator is loaded.  if it is, then when it is T,
;;; send-control will call into the server after the message is sent.
;;; the server will then return when it has something to say to the
;;; client.
;;;
;;; The bottom line is this:  If you aren't planning on running the client
;;; and server in the same process (something the system wasn't designed
;;; for anyway), then it doesn't make a bit of difference _what_ you
;;; do with *give-control-to-server*.
;;;



;;;
;;; RUN-DEMO-CLIENT
;;;
;;; Starts up the interactive interface in the client, with a truck
;;; equipped for coping with the multi-agent world
;;; Note that the multi-agent-world must be running on the server
;;;

(defun run-demo-client (&rest keys &key truck-id &allow-other-keys)
  (if truck-id
      (apply #'start-client :client #'friendly-interactive-client
	     :truck-form `(make-cooperative-truck :truck-id ,truck-id) keys)
    (apply #'start-client :client #'friendly-interactive-client
	   :truck-form '(make-cooperative-truck) keys)))
