;***************************************************************************
; OBJECTS.LISP
;***************************************************************************
;  Code for making boxes, crates, and other things that display in icons

(defvar *obj-number* 0)

(defclass icon-obj  ()
  ((kind-id    :accessor kind-id    :initarg :kind-id)
   (id-string  :accessor id-string :initarg :id-string)
   (unique-id  :accessor unique-id  :initarg :unique-id)))

(defun make-unique-icon-obj (sym)
  (really-build-object sym (incf *obj-number*)))

(defun really-build-object (sym num)
  (let* ((the-string 
		  (concatenate 'string 
					   (copy-seq (symbol-name sym))
					   "."
					   (format nil "~d" num)))
		 (the-symbol (intern the-string)))
	(make-instance 'icon-obj 
				   :kind-id sym 
				   :id-string thr-string
				   :unique-id the-symbol)))

;*************************************************************************

(defun make-box-obj ()
  (make-unique-icon-obj 'box))

(defun make-crate-obj ()
  (make-unique-icon-obj 'crte))

