;*****************************************************************************
;  WORLDS.LISP

(defun make-world (name sectors history-list location-list  road-list
						&optional (display-info nil))
  (let ((the-world 
		 (make-instance 'world
						:id name
						:num-sectors sectors
						:history-list history-list
						:map (make-map :node-list location-list 
									   :road-list road-list 
									   :display-info display-info))))
	(mapc #'(lambda (x) (setf (environment x) the-world)) location-list)
    (mapc #'(lambda (x) (setf (environment x) the-world)) road-list)
    (world-reset the-world)
	the-world))

;************************************************************************
; Global proerties and history lists
; ----------------------------------

(defvar *history-list* '())
(defvar *current-state* nil)

(defun set-new-history (num-sectors hist-list)
  (setf *history-list* hist-list)
  (setf *current-state* (fill (make-array (+ 1 num-sectors)) nil))
  (values))

(defun process-history-list (current-time)
  (cond
   ((null *history-list*)  (values))
   (t (let ((next-change (car *history-list*)))
		(cond 
		 ((>= current-time (time->number (car next-change)))
		  (t-iterate -*- ((changes (cdr next-change)))
			(cond 
			 ((null changes) 
			  (values))
			 (t (let ((property (caar changes))
					  (sector (cadar changes))
					  (value (caddar changes)))
				  (setf (svref *current-state* sector)
						(cons (cons property value)
							  (delete property 
									  (svref *current-state* sector)
									  :test #'(lambda (x y) (eq x (car y)))))))
				(-*- (cdr changes))
				(setf *history-list* (cdr *history-list*))
				(process-history-list current-time)))))
		 (t (values)))))))

(defun current-global-value (property sector)
  (cdr (assq property (svref *current-state* sector))))

(defmacro declare-global-property (name)
  `(defun ,name (obj)
     (let ((sector (map-sector obj)))
       (if (null sector)
           nil
           (current-global-value ',name sector)))))

(declare-global-property day-time)
(declare-global-property weather)
(declare-global-property enemy-activity)
