(comment (herald support))

; ------------------------------------------------------------------------------
; * Definitions for truck support objects *
; -----------------------------------------
; --------------------------------------------------------------------
; * Definitions for FUEL *
; ------------------------
; * Define the liquid "FUEL"

(si.declare-liquid 'fuel '(fuel flammable))

; * Define fuel drums for getting more fuel


(defun si.make-full-fuel-drum (capacity &optional (id nil))
  (let ((drum (si.make-vessel-generic id
                                      'fuel-drum
                                      capacity
                                      capacity
                                      nil
                                      nil)))
    (setf (liquid-held drum) 'fuel)
    (pour-in drum capacity)
    drum))

; --------------------------------------------------------------------
; * Definitions for TIRES *
; -------------------------
; * Define the objects "TIRES"

(defvar *si.tire-size* 4)

(defun si.make-new-tires (kind)
  (si.make-thing-generic (make-unique-id 'tire)
                         (list kind 'tires)
                         *si.tire-size*
                         nil))

; --------------------------------------------------------------------
; * Definitions for STANDARD TRUCK *
; ----------------------------------
; * Define fuel tanks for robot trucks (start with 1/2 a tank)

(defun si.make-fuel-bay (id capacity visibles)
  (let ((fuel-bay (si.make-vessel-generic id
                                          'fuel-bay
                                          capacity
                                          0
                                          '(undefined-tool)
                                          visibles)))
    (setf (liquid-held fuel-bay) 'fuel)
    (pour-in fuel-bay (/ capacity 2))
    fuel-bay))

; * Define tire bays for robot trucks (start with standard tires)

(defun si.make-tire-bay (id)
  (let ((tire-bay (si.make-container-generic id
                                             'tire-bay
                                             *si.tire-size* ;capacity
                                             0              ;bigness
                                             '(undefined-tool)
                                             nil))
        (tires (si.make-new-tires 'standard-tires)))
    (put-in tire-bay tires)
    tire-bay))

; * Define weapon bays for robot trucks (start empty)

(defvar *si.weapon-size* 10)

(defun si.make-weapon-bay (id)
  (si.make-container-generic id
                             'weapon-bay
                             *si.weapon-size*
                             0
                             '(undefined-tool)
                             '(enemy-unit)))

; * Define cargo bays for robot trucks (start empty)

(defun si.make-cargo-bay (id capacity visibles)
  (si.make-container-generic id
                             'cargo-bay
                             capacity
                             0
                             '(undefined-tool)
                             visibles))

; * Define robot arms for robot trucks (start folded)

(defun si.make-robot-arm (id capacity visibles clumsiness)
  (si.make-arm-generic id 'robot-arm capacity visibles clumsiness))

; * Define a STANDARD TRUCK

(defun si.make-standard-truck (id arms bays fuel base-mph base-mpg visibles)
  (let ((fuel-bay (si.make-fuel-bay 'fuel-gauge fuel nil))
        (tire-bay (si.make-tire-bay 'tire-bay))
        (weapon-bay (si.make-weapon-bay 'weapon-bay)))
   (si.make-truck-generic id
                           'robot-truck
                           arms
                           bays
                           fuel-bay
                           tire-bay
                           weapon-bay
                           base-mph
                           base-mpg
                           (cons 'enemy-unit visibles))))

; -------------------------------------------------------------------
; * Definitions for WEAPONS *
; ---------------------------

(si.declare-liquid 'ammo '(ammo explosive))

; * Define boxes for ammunition

(defun si.make-full-ammo-box (capacity)
  (let ((box (si.make-vessel-generic nil
                                     'ammo-box
                                     capacity
                                     (truncate capacity 2)
                                     nil
                                     nil)))
    (setf (liquid-held box) 'ammo)
    (pour-in box capacity)
    box))


(defun si.make-weapon-generic (id kind
                                  capacity
                                  bigness
                                  tool-needs
                                  effectiveness
                                  shots-per-turn)
  (let ((new-thing (make-instance 'weapon
                                  :id id
                                  :kind kind
                                  :capacity capacity
                                  :bigness bigness
                                  :tool-needs tool-needs
                                  :effectiveness effectiveness
                                  :shots-per-turn shots-per-turn)))
    (setf (space-empty new-thing) capacity)
    (if (symbolp kind)
      (setf (kind new-thing) (list kind)))
    (setf (id-key new-thing) (if (null id) (make-unique-id 'weapon) nil))
    new-thing))
