;;; Note that when the documentation refers to operations,
;;; everything is now implemented in CLOS classes, instances
;;; and generic functions


; --------------------------------------------------------------------
; ** Simulator support for THINGOIDS
; ----------------------------------------------------------
;
; Things defined in this file:
; Object builders:
;  (SI:MAKE-THING-GENERIC id kind bigness-num tools)
;
; This file makes reference to things in OPERATIONS
;                                        LOWLEVEL
;                                        THINGOID-DEFS
; --------------------------------------------------------------------
; ** Simulator support for THINGOIDS
; ----------------------------------
; Solid objects are all of type THINGOID.  Each must be constructed
;  indivdually.  It should be kept in mind that when solid objects
;  are to be created and destroyed often (ie. enemy soldiers,
;  grenades and the like) they should exist as pools (see 'T' manual)
;  to minimize consing.
; THINGOIDS can be placed in PARCELS of type CONTAINER but not
;  parcels of type VESSEL. (see VESSELS below)
; --------------------------------------------------------------------
; * Generic THINGOID object constructor
; -------------------------------------
; This function makes a single object of a given type.  The arguments
;  determine the properties of the object in the simulation.  Generic
;  THINGOIDS are entirely passive.  Note that enemy troops, tires and
;  weapons are generic objects.
;
; (SI:MAKE-THING-GENERIC id kind bigness-num tools)
;  -    id: This should be a globally unique symbol differentiating
;            the object from all others.
;  -  kind: A symbol or list of symbols describing the classes that
;            the object belongs to.  The first symbol in this argument
;            is known as the objects KIND-ID and is used for display
;            purposes.
;  - bigness-num: This argument is an integer giving the pseudo-size
;            of the object.
;  - tools: A list of object classes that the robot arm must already
;            be holding before this object can be picked up.



(defun si.make-thing-generic (id kind bigness tools)
  (let ((new-thing (make-instance 'thingoid
                                  :id id
                                  :kind kind
                                  :bigness bigness
                                  :tool-needs tools)))
    (if (null id)
      (setf (id-key new-thing) (make-unique-id 'thing)))
    (if (symbolp kind)
      (setf (kind new-thing) (list kind)))
    new-thing))

;; should be able to do this stuff with methods but I'm not sure how

 
