;;; Note that when the documentation refers to operations,
;;; everything is now implemented in CLOS classes, instances
;;; and generic functions

;;; Everything that was a PACKAGE is now a PARCEL because of 
;;; conflicts in common lisp

;;; check printing etc

; --------------------------------------------------------------------
; ** Simulator support for THINGOIDS, CONTAINERS and VESSELS
; ----------------------------------------------------------
;
; Things defined in this file:
;
; This file makes reference to things in OPERATIONS
;                                        LOWLEVEL
;                                        THINGOID-DEFS
;                                        SIM-OBJ-DEFS
; --------------------------------------------------------------------
; ** Simulator support for THINGOID CONTAINERS
; --------------------------------------------
; THINGOIDS can be put in CONTAINERS.  A CONTAINER is a thingoid that
;  can hold other thingoids and a generic container is a thingoid 
;  itself.  When a thingoid is inside a container it is invisible to
;  all other objects in the simulation unless it is of a class for
;  which the container is invisible.  Examples of such classes are
;  paper containers and radioactive thingoids.
; CONTAINERS can be placed inside other containers but not VESSELS.
; Both CONTAINERS and VESSELS are parcelS

(defclass parcel
  (thingoid sim-object)
  ((capacity :accessor capacity
             :initarg :capacity)
   (visibles :accessor visibles
             :initarg :visibles
             :initform '())
   (space-empty :accessor space-empty
                :initarg :space-empty)
   ))



