(comment (herald messages))

; --------------------------------------------------------------------
; * Special functions for reporting hardware and sensory data
; -----------------------------------------------------------
; 
; *sensor-datum-pool* is used to store a set of sensor datum templates so that
;                     garbage collection can be reduced.

(defvar *sensor-datum-pool*
        (make-pool 'sensor-datum-pool
                   #'(lambda ()
                       (fill (make-array 5) nil))))

(defun recycle-sensor-datum (datum)
  (return-to-pool *sensor-datum-pool* datum))

; ------------------------------------------------------------------------------

(let ((current-hardware-error nil)
      (current-sensor-data nil))
  
  (defun post-hardware-error (new-error)
    (setf current-hardware-error new-error)
    nil)

  (defun post-sensor-datum (arg0 arg1 arg2 arg3 arg4)
    (let ((datum (obtain-from-pool *sensor-datum-pool*)))
      (setf (svref datum 0) arg0)
      (setf (svref datum 1) arg1)
      (setf (svref datum 2) arg2)
      (setf (svref datum 3) arg3)
      (setf (svref datum 4) arg4)
      (setf current-sensor-data (cons datum current-sensor-data)))
    t)

  (defun read-hardware-error ()
    (let ((xerror current-hardware-error))
      (setf current-hardware-error nil)
      xerror))

  (defun read-sensor-data ()
    (let ((data current-sensor-data))
      (setf current-sensor-data nil)
      data))
  )

(defun read-postings ()
  (values (read-hardware-error) (read-sensor-data)))

