;; This file contains non-standard common-lisp functions required to run code
;; generated by T2CL program.

(in-package 'user)

;; COMMENT: Ignores arguments, returns no value.

(defmacro comment (&rest ignore)
  (declare (ignore ignore))
  '(values))

(defconstant else T)

(defun true? (item)
  (and item t))

(defun map! (proc lst)
  (do ((subl lst (cdr subl)))
      ((null subl) lst)
      (rplaca subl (funcall proc (car subl)))))

(defun neq (a b)
  (not (eq a b)))

(defun fx+ (&rest args)
  (apply #'+ args))

(defun assq (thing l)
  (assoc thing l))

;; This is a version of cond that implements the => functionality
;; from the tea version.

(defmacro t-cond (&body clauses)
  (let ((temp (gensym)))
    `(let (,temp)
      (cond
	,@(mapcar #'(lambda (clause)
		      (if (eq (cadr clause) '=>)
			  `((setf ,temp ,(car clause))
			    (funcall ,(caddr clause) ,temp))
			  clause))
		  clauses)))))

(defun sublist (lst start count)
  (subseq lst start (+ start count)))

(defun enforce (pred val)
  (if (funcall pred val)
      val
      (error "~a fails a type constraint" val)))

;; COMMENT: Ignores arguments, returns no value.

(defmacro t-import (&rest ignore)
  (declare (ignore ignore))
  '(values))

(defun check-arg (predicate object procedure)
  (if (funcall predicate object)
      object
      (error "~a does fails a constraint in ~a" object procedure)))


(defstruct undefined args)
(defun undefined-value (&rest args)
  (make-undefined :args args))


;;; The select used in tea.

(defmacro t-select (key &body expressions)
  (let ((clauses nil)
	(temp (gensym)))
    (dolist (c expressions)
      (if (eq (car c) 'else)
	  (push `(t . ,(cdr c)) clauses)
	(push 
	 `((member ,temp (list ,@(car c))) . ,(cdr c))
	 clauses)))
    `(let ((,temp ,key))
       (cond . ,(nreverse clauses)))))

(defmacro compose (&rest procedures)
  (setf procedures (reverse procedures))
  (let
      ((out `(apply ,(car procedures) args)))
    (dolist (proc (cdr procedures))
	    (setf out `(funcall ,proc ,out)))
    `#'(lambda (&rest args)
	 ,out)))

(defun callable-function-p (item)
  (if (symbolp item)
      (fboundp item)
      (eq (type-of item) 'system::procedure)))


;;;;  POOLS
;; Note: ignores identifier.

(defun make-pool (identifier generator &rest ignore)
  (declare (ignore identifier))
  (declare (ignore ignore))
  (let
      ((pool nil))
    #'(lambda (&key function object)
	(case function
	      (:return (push object pool))
	      (:obtain (if pool 
			  (pop pool)
			(funcall generator)))))))

(defun obtain-from-pool (pool)
  (funcall pool :function :obtain))

(defun return-to-pool (pool object)
  (funcall pool :function :return :object object))
			
;;-----------------------------

(defun vset (array position item)
  (setf (aref array position) item))


;; does nothing.  Useful as placeholder for where t code was deleted.

(defun null-function (&rest ignore)
  (declare (ignore ignore))
  (values))

(defun set-hpos (stream position)
  (format stream "~VT" position))


(defun proper-list-p (lst)
  (null (cdr (last lst))))


(defun positive-p (num)
  (> num 0))

(defun non-negative-p (num)
  (>= num 0))

(defmacro t-iterate (name arglist &body body)
  `(labels ((,name ,(mapcar #'car arglist)
	     ,@body))
    (,name ,@(mapcar #'cadr arglist))))

;;;; cformat, (cmsg), bs-text,

;; Try to keep the conditionality of cmsg.


(defun symbol-pname-length (sym)
  (length (symbol-name sym)))


(let ((hash-table (make-hash-table :test #'eq))
      (unhash-table (make-hash-table :test #'eq))
      (count 0))

  (defun object-hash (object)
    (cond
     ((gethash object hash-table))
     (t
      (setf (gethash (incf count)
		     unhash-table)
	    object)
      (setf (gethash object hash-table)
	    count))))

  (defun object-unhash (integer)
    (gethash integer unhash-table))

  (defun object-remove-hash (object)
    (let ((hash-val (gethash object hash-table)))
      (when hash-val
	    (remhash object hash-table)
	    (remhash hash-val unhash-table))))

  (defun object-rehash (object)
    (object-remove-hash object)
    (object-hash object))

  (defun object-hash-table ()
    hash-table)

  (defun set-object-hash-table (table)
    (setf hash-table table))

  (defsetf object-table set-object-hash-table)

  (defun object-unhash-table ()
    unhash-table)

  (defun set-object-unhash-table (table)
    (setf unhash-table table))

  (defsetf object-unhash-table set-object-unhash-table))

(defun char->digit (character &optional (base 10))
  (let ((char character))
    (cond
     ((> (setf char (char-code (char-upcase char))) 64)
      (if (>= (setf char (- char 55)) base)
	  (error "~a is not a digit in base ~a" character base)
	char))
     ((> char 47)  ;; code for #\0
      (if (>= (setf char (- char 48)) base)
	  (error "~a is not a digit in base ~a" character base)
	char)))))

;; This is a particularly nauseating hack!  It depends on no copier and no
;; conc-name being specified to defstruct.  

(defun copy-structure (structure)
  (let
      ((copy-fn 
	(intern (string-append 
		 "COPY-" 
		 (symbol-name (type-of structure))))))
    (if (fboundp copy-fn)
	(funcall copy-fn structure)
      (error "Don't know how to copy ~a" structure))))

(defvar *wrap-column* 80) ;; variable instead of function

(defun copy-hash-table (hash-table &key (test #'eql) (size 20) (rehash-size 1.5))
  (let ((new (make-hash-table :test test :size size :rehash-size rehash-size)))
    (maphash #'(lambda (key val)
                 (setf (gethash key new) val))
             hash-table)
    new))


(defun t-copy-table (table &rest ignore)
  (declare (ignore ignore))
  (copy-hash-table table))
                
(defun memq (thing lst)
  (member thing lst :test #'eq))
