;*************************************************************************
;
;  Make a simple displayer --- one that just echoes each command back 
;  to you.   Entry point is 
;    (make-displayer)
;

;***************************

(defclass display-obj  () ())

;************************************************************************

(defmethod dm-add ((self display-obj) bay-name obj)
  (format t "DM-adding ~a to bay ~a~%" obj bay-name))

(defmethod dm-del ((self display-obj) bay-name obj)
  (format t "DM-deleting ~a to bay ~a~%" obj bay-name))

(defmethod dm-empty ((self display-obj) bay-name)
  (format t "DM-emptying ~a~%" bay-name))

(defmethod dm-set ((self display-obj) gauge-name val)
  (format t "DM-setting gauge ~a to value ~a~%" gauge-name val))

(defmethod dm-move ((self display-obj) arm-name new-loc)
  (format t "DM-moving arm ~a to location ~a~%" arm-name new-loc))

(defmethod dm-mnes ((self display-obj) arm-name bay-or-loc-name)
  (format t "DM-mnes arm ~a to location ~a~%" arm-name bay-or-loc-name))

(defmethod dm-speak ((self display-obj) x) 
  (format t "DM-speaking ~a~%" x))

(defmethod dm-close ((self display-obj))
  (format t "DM-closing~%"))

(defmethod dm-redraw ((self display-obj) appendage obj)
  (format t "DM-redrawing ~a/~a~%" appendage obj))

;******************************************************************

(defun make-displayer (&rest args-to-ignore)
  (declare (ignore args-to-ignore))
  (make-instance 'display-obj))

;******************************************************************
;
; function used as arg to make-node

(defun make-window (a b c d))



