(defmacro disp.with-font (font-id &rest body)
  `(let* ((fun-to-call #'(lambda () ,@body))
		  (old-font nil))
	 (setf old-font (grafp_get_font))
	 (grafp_set_font ,font-id)
 	(prog1
      (funcall fun-to-call)
	  (grafp_set_font old-font))))

(defmacro disp.with-clip-window (g-clip-window &rest body)
  `(let* ((lamb #'(lambda () ,@body)))
	 (multiple-value-bind (old-origin-x old-origin-y)
						  (grafp_get_origin)
       (let* ((tmp-1 (grafp_set_origin (x-coord ,g-clip-window) 
									   (y-coord ,g-clip-window)))
			  (fun-result (funcall lamb))
			  (junk (grafp_set_origin old-origin-x old-origin-y)))
		 (declare (ignore tmp-1 junk))
		 fun-result))))

(defmacro disp.with-origin (g-clip-window &rest body)
  `(let* ((lamb #'(lambda () ,@body)))
	 (multiple-value-bind (old-origin-x old-origin-y)
						  (grafp_get_origin)
	   (let* ((tmp-1 (grafp_set_origin (x-coord ,g-clip-window) 
									   (y-coord ,g-clip-window)))
			  (fun-result (funcall lamb))
			  (junk (grafp_set_origin old-origin-x old-origin-y)))
		 (declare (ignore tmp-1 junk))
	fun-result))))


(defmacro disp.with-erasure (&rest body)
  `(let* ((lamb #'(lambda () ,@body))
		  (old-erasure (grafp_get_erasure))
		  (junk (grafp_set_erasure 1))
          (fun-result  (funcall lamb))
		  (more-junk (grafp_set_erasure old-erasure)))
	 (declare (ignore junk) (ignore more-junk))
	fun-result))

